/*
 * Decompiled with CFR 0.152.
 */
package com.pushchamp.utils;

import com.pushchamp.PushChamp;
import com.pushchamp.utils.Constants;
import com.pushchamp.utils.VersionInfo;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;

public class URLConnection {
    public static String TAG = "URLConnection";

    public static class Builder {
        private String apiEvent;
        private String messageBody;

        public Builder setApi(String apiEvent) {
            this.apiEvent = apiEvent;
            return this;
        }

        public Builder setMessageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public HttpURLConnection build() {
            HttpURLConnection conn = null;
            try {
                URL url = new URL(VersionInfo.BASE_URL + VersionInfo.SEPARATOR + VersionInfo.version + VersionInfo.SEPARATOR + this.apiEvent + VersionInfo.SEPARATOR);
                conn = (HttpURLConnection)url.openConnection();
                conn.setReadTimeout(10000);
                conn.setConnectTimeout(15000);
                conn.setRequestMethod(VersionInfo.POST_METHORD);
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setInstanceFollowRedirects(false);
                conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                if (this.messageBody != null) {
                    conn.setFixedLengthStreamingMode(this.messageBody.getBytes().length);
                }
                conn.setUseCaches(false);
                if (this.messageBody != null) {
                    BufferedOutputStream os = new BufferedOutputStream(conn.getOutputStream());
                    ((OutputStream)os).write(this.messageBody.getBytes());
                    ((OutputStream)os).flush();
                    ((OutputStream)os).close();
                }
            }
            catch (MalformedURLException e) {
                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
            }
            catch (ProtocolException e) {
                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
            }
            catch (UnsupportedEncodingException e) {
                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
            }
            catch (UnknownHostException e) {
                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
            }
            catch (IOException e) {
                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
            }
            return conn;
        }
    }
}

