/*
 * Decompiled with CFR 0.152.
 */
package com.pushchamp.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import com.pushchamp.PushChamp;
import com.pushchamp.database.EventsModel;

public class DatabaseHandler
extends SQLiteOpenHelper {
    public static String TAG = "DatabaseHandler";
    private static final int DATABASE_VERSION = 1;
    private static final String DATABASE_NAME = "eventsManager";
    private static final String TABLE_EVENTS = "events";
    private static final String KEY_ID = "id";
    private static final String KEY_EVENT = "events";
    private static final String KEY_SSID = "ssid";
    private static final String KEY_APP = "app";
    private static final String KEY_EV = "ev";
    private static final String KEY_TY = "ty";
    private static final String KEY_TS = "ts";
    private static final String KEY_TFS = "tfs";
    private static final String KEY_PF = "pf";
    private static final String KEY_ET = "et";

    public DatabaseHandler(Context context) {
        super(context, DATABASE_NAME, null, 1);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setWriteAheadLoggingEnabled(true);
        }
    }

    public void onCreate(SQLiteDatabase db) {
        String CREATE_EVENTS_TABLE = "CREATE TABLE events(id INTEGER PRIMARY KEY,ssid TEXT,app TEXT,ev TEXT,ty TEXT,ts TEXT,tfs TEXT,pf TEXT,et TEXT)";
        db.execSQL(CREATE_EVENTS_TABLE);
    }

    public void onUpgrade(SQLiteDatabase db, int oldversion, int newversion) {
        db.execSQL("DROP TABLE IF EXISTS events");
        this.onCreate(db);
    }

    public void onConfigure(SQLiteDatabase db) {
        super.onConfigure(db);
        if (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT < 16) {
            db.enableWriteAheadLogging();
        } else {
            PushChamp.getLogger().w(TAG + " EventsModel pending Count", "WAL is not supported on API levels below 11.");
        }
    }

    public void addEvent(EventsModel event) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put(KEY_SSID, event.getSsid());
        values.put(KEY_APP, event.getApp());
        values.put(KEY_EV, event.getEv());
        values.put(KEY_TY, event.getTy());
        values.put(KEY_TS, Long.valueOf(event.getTs()));
        values.put(KEY_TFS, Long.valueOf(event.getTfs()));
        values.put(KEY_PF, event.getPf());
        if (!event.getEt().equals("{}")) {
            values.put(KEY_ET, event.getEt());
        }
        long res = db.insertWithOnConflict("events", null, values, 5);
        PushChamp.getLogger().d(TAG + " EventsModel pending Count", "" + res);
        if (res > 0L) {
            db.close();
        }
    }

    public void deleteEvent(String id) {
        SQLiteDatabase db = this.getWritableDatabase();
        db.delete("events", "id = ?", new String[]{id});
        db.close();
    }

    public String getEvents(int id) {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query("events", new String[]{KEY_ID, "events"}, "id=?", new String[]{String.valueOf(id)}, null, null, null, null);
        if (cursor != null) {
            cursor.moveToFirst();
        }
        EventsModel event = new EventsModel(Integer.parseInt(cursor.getString(0)), cursor.getString(1), cursor.getString(2), cursor.getString(3), cursor.getString(4), cursor.getLong(5), cursor.getLong(6), cursor.getString(7), cursor.getString(8));
        return event.toString();
    }

    public Cursor getEvents() {
        String countQuery = "SELECT  * FROM events";
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.rawQuery(countQuery, null);
        return cursor;
    }

    public int getEventsCount() {
        String countQuery = "SELECT  * FROM events";
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.rawQuery(countQuery, null);
        int count = cursor.getCount();
        cursor.close();
        return count;
    }
}

