/*
 * Decompiled with CFR 0.152.
 */
package com.pushchamp;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class SharedPreferencesLoader {
    private final Executor mExecutor = Executors.newSingleThreadExecutor();

    public Future<SharedPreferences> loadPreferences(Context context, String name, OnPrefsLoadedListener listener) {
        LoadSharedPreferences loadSharedPrefs = new LoadSharedPreferences(context, name, listener);
        FutureTask<SharedPreferences> task = new FutureTask<SharedPreferences>(loadSharedPrefs);
        this.mExecutor.execute(task);
        return task;
    }

    private static class LoadSharedPreferences
    implements Callable<SharedPreferences> {
        private final Context mContext;
        private final String mPrefsName;
        private final OnPrefsLoadedListener mListener;

        public LoadSharedPreferences(Context context, String prefsName, OnPrefsLoadedListener listener) {
            this.mContext = context;
            this.mPrefsName = prefsName;
            this.mListener = listener;
        }

        @Override
        public SharedPreferences call() {
            SharedPreferences ret = this.mContext.getSharedPreferences(this.mPrefsName, 0);
            if (null != this.mListener) {
                this.mListener.onPrefsLoaded(ret);
            }
            return ret;
        }
    }

    static interface OnPrefsLoadedListener {
        public void onPrefsLoaded(SharedPreferences var1);
    }
}

