/*
 * Decompiled with CFR 0.152.
 */
package com.pushchamp;

import android.content.ContentResolver;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.provider.Settings;
import com.pushchamp.PushChamp;
import com.pushchamp.events.EventApiCall;
import com.pushchamp.utils.Constants;
import com.pushchamp.utils.VersionInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class PushchampWrapper
extends AsyncTask<Void, Void, String> {
    private String subscription_id;
    private String pnToken;
    private HashMap<String, String> add_tags;
    private String[] delete_tags;
    private static final String TAG = PushchampWrapper.class.getSimpleName();
    private static String PLATFORM = "android";
    private Context ctx;
    private String app;
    private String[] add_groups;
    private String[] delete_groups;

    public PushchampWrapper(Context ctx, String app, String pnToken, HashMap<String, String> add_tags, String[] delete_tags, String[] add_groups, String[] delete_groups) {
        this.ctx = ctx;
        this.app = app;
        this.subscription_id = this.ctx.getSharedPreferences("PushchampPrefs", 0).getString("subscription_id", null);
        this.pnToken = pnToken;
        this.add_tags = add_tags;
        this.delete_tags = delete_tags;
        this.add_groups = add_groups;
        this.delete_groups = delete_groups;
    }

    protected String doInBackground(Void ... p) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        String android_id = Settings.Secure.getString((ContentResolver)this.ctx.getContentResolver(), (String)"android_id");
        params.put("app", this.app);
        if (this.add_tags != null) {
            JSONObject add_tags_json = new JSONObject();
            try {
                for (Map.Entry<String, String> entry : this.add_tags.entrySet()) {
                    add_tags_json.put(entry.getKey(), (Object)entry.getValue());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            params.put("add_tags", add_tags_json.toString());
        }
        if (this.delete_tags != null) {
            JSONArray delete_tags_json = new JSONArray();
            for (int i = 0; i < this.delete_tags.length; ++i) {
                delete_tags_json.put((Object)this.delete_tags[i]);
            }
            params.put("delete_tags", delete_tags_json.toString());
        }
        if (this.subscription_id != null) {
            params.put("subscription_id", this.subscription_id);
        }
        if (this.add_groups != null) {
            JSONArray add_groups_json = new JSONArray();
            for (int i = 0; i < this.add_groups.length; ++i) {
                add_groups_json.put((Object)this.add_groups[i]);
            }
            params.put("add_groups", add_groups_json.toString());
        }
        if (this.delete_groups != null) {
            JSONArray delete_groups_json = new JSONArray();
            for (int i = 0; i < this.delete_groups.length; ++i) {
                delete_groups_json.put((Object)this.delete_groups[i]);
            }
            params.put("delete_groups", delete_groups_json.toString());
        }
        params.put("platform", PLATFORM);
        params.put("hardware_id", android_id);
        try {
            JSONObject deviceJSON = new JSONObject();
            deviceJSON.put("android_os", (Object)System.getProperty("os.version"));
            deviceJSON.put("android_api", Build.VERSION.SDK_INT);
            deviceJSON.put("device", (Object)Build.DEVICE);
            deviceJSON.put("model", (Object)Build.MODEL);
            deviceJSON.put("product", (Object)Build.PRODUCT);
            params.put("other", deviceJSON.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.pnToken != null) {
            params.put("notification_token", this.pnToken);
        }
        String response = null;
        try {
            URL url = new URL("https://www.pushchamp.com/subscribe/");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(10000);
            conn.setConnectTimeout(15000);
            conn.setRequestMethod(VersionInfo.POST_METHORD);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            writer.write(this.getQuery(params));
            writer.flush();
            writer.close();
            os.close();
            conn.connect();
            PushChamp.getLogger().d(TAG + " response code", "" + conn.getResponseCode());
            response = PushchampWrapper.getStringFromInputStream(conn.getInputStream());
            try {
                JSONObject respJson = new JSONObject(response);
                PushChamp.getLogger().d(TAG + "response", "" + respJson.toString());
                if (respJson.getString("status").equals("success")) {
                    String sid = respJson.getString("subscription_id");
                    PushChamp.getLogger().d(TAG + "sid", "" + sid);
                    this.ctx.getSharedPreferences("PushchampPrefs", 0).edit().putString("subscription_id", sid).apply();
                }
            }
            catch (JSONException e) {
                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
            }
        }
        catch (MalformedURLException e) {
            PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
        }
        catch (ProtocolException e) {
            PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
        }
        catch (UnsupportedEncodingException e) {
            PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
        }
        catch (IOException e) {
            PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
        }
        catch (Exception e) {
            PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
        }
        return response;
    }

    protected void onPostExecute(String result) {
        super.onPostExecute((Object)result);
        try {
            if (this.ctx.getSharedPreferences("PushchampPrefs", 0).getString("subscription_id", null) != null && this.ctx.getSharedPreferences("PushchampPrefs", 0).getString("subscription_id", null).length() > 1) {
                new EventApiCall().startEventCall(this.ctx, this.ctx.getSharedPreferences("PushchampPrefs", 0).getString("subscription_id", null));
            }
        }
        catch (Exception e) {
            PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
        }
    }

    private String getQuery(TreeMap<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(key, "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(value, "UTF-8"));
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getStringFromInputStream(InputStream is) {
        if (is == null) {
            return null;
        }
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
                }
            }
        }
        return sb.toString();
    }
}

