/*
 * Decompiled with CFR 0.152.
 */
package com.pushchamp;

import android.content.Context;
import android.content.SharedPreferences;
import com.pushchamp.PushchampPreferences;
import com.pushchamp.PushchampSubscription;
import com.pushchamp.database.DatabaseHandler;
import com.pushchamp.database.EventsModel;
import com.pushchamp.events.EventApiCall;
import com.pushchamp.events.EventsApiGenerator;
import com.pushchamp.events.custom.Events;
import com.pushchamp.log.DefaultLogger;
import com.pushchamp.log.Logger;

public class PushChamp {
    static Logger LOGGER = new DefaultLogger();
    static volatile PushChamp singleton;
    public static boolean debug;
    private PushchampSubscription pushChampSubscription;
    Context context;

    public static void setLogEnabled(int logLevel) {
        debug = true;
        LOGGER = new DefaultLogger(logLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PushChamp enableTrackingWith(Context context) {
        if (singleton != null) return singleton;
        Class<PushChamp> clazz = PushChamp.class;
        synchronized (PushChamp.class) {
            if (singleton != null) return singleton;
            PushChamp.setPushChamp(new Builder(context).initialize());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static boolean isDebuggable() {
        return debug;
    }

    private static void setPushChamp(PushChamp pushChamp) {
        singleton = pushChamp;
        pushChamp.init();
    }

    private void init() {
        this.pushChampSubscription.register();
        new EventsApiGenerator(this.context).registerEventsActivityLifecycleCallbacks();
    }

    private PushChamp(Context context) {
        this.context = context;
        if (this.pushChampSubscription == null) {
            this.pushChampSubscription = new PushchampSubscription(context);
        }
    }

    static {
        debug = false;
    }

    public static class Builder {
        private final Context context;
        private DatabaseHandler databaseHandler;
        boolean customEvent = false;
        SharedPreferences sharedPreferences;
        private String appName;

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.context = context;
        }

        public Builder pushChampCustomEventHandler(Events event, Context context) {
            this.appName = PushchampPreferences.getAppName(context);
            this.customEvent = true;
            this.sharedPreferences = context.getSharedPreferences("PushchampPrefs", 0);
            long currentTime = System.currentTimeMillis();
            long tfsDifferenceInTime = (currentTime - this.sharedPreferences.getLong("ts", 0L)) / 1000L;
            this.databaseHandler = new DatabaseHandler(context);
            this.databaseHandler.addEvent(new EventsModel(this.sharedPreferences.getString("sessionID", ""), this.appName, event.getCustomType(), "userEvent", currentTime, tfsDifferenceInTime, "android", event.getCustomEventData()));
            this.databaseHandler.close();
            return this;
        }

        public void build() {
            if (this.customEvent && this.sharedPreferences != null && this.sharedPreferences.getString("subscription_id", null) != null && this.sharedPreferences.getString("subscription_id", null).length() > 1) {
                new EventApiCall().startEventCall(this.context, this.sharedPreferences.getString("subscription_id", null));
            }
        }

        public PushChamp initialize() {
            return new PushChamp(this.context);
        }
    }

    public static class LOG_LEVEL {
        public static int ERROR = 6;
        public static int WARN = 5;
        public static int INFO = 4;
        public static int DEBUG = 3;
        public static int VERBOSE = 2;
    }
}

