package com.pushchamp.events.custom;

import com.pushchamp.PushChamp;
import com.pushchamp.utils.VersionInfo;

import java.util.Locale;
import java.util.Map;

/**
 * Created by ramesh on 27/12/16.
 */

public class PushChampEventAnalyser
{

    /**
     * Analyser class handle the validation the Custom
     * event name length and total count of event data
     */
         final int maxNumAttributes=VersionInfo.MAXIMUM_EVENT_ATTRIBUTES;
         final int maxStringLength=VersionInfo.MAXIMUM_EVENT_NAME_LENGTH;
         boolean debuggerEnabled=PushChamp.isDebuggable();


    /**
     * Check whether eventname is longer that Restricted Length
     * @param eventName passing the event name
     * @return String
     */
        public String limitStringLength(String eventName) {
            if(eventName.length() > this.maxStringLength) {
                String message = String.format(Locale.US, "String is too long, stripping  %d data", new Object[]{Integer.valueOf(this.maxStringLength)});
                this.handleException(new IllegalArgumentException(message));
                return eventName.substring(0, this.maxStringLength);
            } else {
                return eventName;
            }
        }

    /**
     * Check whether key value is null
     * @param object passing the object
     * @param paramName passing the paramName
     * @return boolean
     */
        public boolean isNull(Object object, String paramName) {
            if(object == null) {
                this.handleException(new NullPointerException(paramName + " must not be null"));
                return true;
            } else {
                return false;
            }
        }

    /**
     * Check whether custom event attributes is longer that Restricted data count
     * @param attributeMap passing the custom event attributes
     * @param  key   passing key value
     * @return Boolean
     */
        public boolean checkForEventAttributeSize(Map<String, Object> attributeMap, String key) {
            if(attributeMap.size() >= this.maxNumAttributes && !attributeMap.containsKey(key)) {
                String message = String.format(Locale.US, "Max Limit of %d attributes reached, skipping attribute", new Object[]{Integer.valueOf(this.maxNumAttributes)});
                this.handleException(new IllegalArgumentException(message));
                return true;
            } else {
                return false;
            }
        }

    /**
     * Handle any exception occur on PushChampEventAnalyser throw error or show the log according to the debuggingmode
     * @param ex passing the exception
     * @return null
     */
        private void handleException(RuntimeException ex) {
            if(this.debuggerEnabled) {
                throw ex;
            } else {
                PushChamp.getLogger().e("PushChampEventAnalyser", "Invalid user input detected", ex);
            }
        }
}