package com.pushchamp.events.custom;

import org.json.JSONObject;

/**
 * Created by ramesh on 27/12/16.
 */
public abstract class PushChampEvent<T extends PushChampEvent> {

    /**
     * abstract class which map the custom events
     * and get the whole created custom event
     */

    //Declare the analyzer to analyses the provided data
    final PushChampEventAnalyser analyser = new PushChampEventAnalyser();

    final PushChampCustomEventHandler customEventData;

    public PushChampEvent() {
        this.customEventData = new PushChampCustomEventHandler(this.analyser);
    }

    /*Add the no of custom events that has created*/
    public T addCustomEventData(String key, String value) {
        this.customEventData.put(key, value);
        return (T) this;
    }

    public T addCustomEventData(String key, Number value) {
        this.customEventData.put(key, value);
        return (T) this;
    }

        /*getting the whole added events in json format to pass to server*/

    public String getCustomEventData() {
        return (new JSONObject(this.customEventData.eventAttributes)).toString();
    }
}

