package com.pushchamp.events.custom;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by ramesh on 27/12/16.
 */

public class PushChampCustomEventHandler {

    /**
     * Event Handler class which put the custom
     * events to map after analysing the data
     */
    final PushChampEventAnalyser eventAnalyser;
    final Map<String, Object> eventAttributes = new ConcurrentHashMap();

    public PushChampCustomEventHandler(PushChampEventAnalyser eventAnalyser) {
        this.eventAnalyser = eventAnalyser;
    }


    /*Keys and value being added
    *after check the validation
    * from PushChampEventAnalyser class
    * @param key- pass the custom key
    * @param value -pass the custom value as String
    * */
    void put(String key, String value) {
        if (!this.eventAnalyser.isNull(key, "key") && !this.eventAnalyser.isNull(value, "value")) {


            key = this.eventAnalyser.limitStringLength(key);
            value = this.eventAnalyser.limitStringLength(value);

            this.setEventData(key, value);
        }

    }

    /*Keys and value being added
        *after check the validation
        * from PushChampEventAnalyser class
        * @param key- pass the custom key
        * @param value -pass the custom value which is Number(float,int etc)
        * */
    void put(String key, Number value) {
        if(!this.eventAnalyser.isNull(key, "key") && !this.eventAnalyser.isNull(value, "value")) {
            key = this.eventAnalyser.limitStringLength(key);
            this.setEventData(key, value);
        }
    }


    /*Pass event data to the map*/
    void setEventData(String key, Object value) {

        //Check if attribute size exceeded if not pass the data to the Map
        if (!this.eventAnalyser.checkForEventAttributeSize(this.eventAttributes, key)) {
            this.eventAttributes.put(key, value);
        }

    }

}
