package com.pushchamp.events.custom;

import android.content.Context;

import com.pushchamp.PushChamp;

/**
 * Created by ramesh on 27/12/16.
 */

public class PushChampCustomEvent{

    /**
     * Class used to handle adding custom events to pushchamp
     */
    public static PushChampCustomEvent getInstance() {
        return PushChampHelper.INSTANCE;
    }
    /*Singleton instance*/
    private static class PushChampHelper{

        private static final PushChampCustomEvent INSTANCE = new PushChampCustomEvent();
    }

    //trackEvent will initialize the tracking process of custom events
    public void trackEvent(Context context, Events event) {
        if(event == null) {
            throw new NullPointerException("event must not be null");
        } else {
            //PushChamp will be enabled to pass the data
            (new PushChamp.Builder(context)).pushChampCustomEventHandler(event,context).build();
        }
    }

}
