package com.pushchamp.events;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;

import com.pushchamp.PushChamp;
import com.pushchamp.PushchampPreferences;
import com.pushchamp.database.DatabaseHandler;
import com.pushchamp.database.EventsModel;
import com.pushchamp.events.custom.Events;
import com.pushchamp.events.custom.PushChampCustomEvent;

import org.json.JSONObject;

import java.util.Random;
import java.util.concurrent.TimeUnit;

import static com.pushchamp.PushchampPreferences.getAppName;

/**
 * Created by munnaz on 9/1/17.
 */

public class SessionGenerator {

    /**
     * Class used to handle adding session generate to pushchamp
     */
    public static SessionGenerator getInstance() {
        return SessionGenerator.PushChampHelper.INSTANCE;
    }
    /*Singleton instance*/
    private static class PushChampHelper{

        private static final SessionGenerator INSTANCE = new SessionGenerator();
    }

     void checkForSessionChange(Context context) {


        boolean isFirstRun = context.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).getBoolean(PushchampPreferences.FIRSTRUN, true);
        String appName = getAppName(context);


        String candidateChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";


        if (isFirstRun) {
            // Code to run once
            String ssid = generateRandomChars(
                    candidateChars, 32);

            SharedPreferences.Editor editor = context.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).edit();
            editor.putBoolean(PushchampPreferences.FIRSTRUN, false);
            editor.putLong("ts", System.currentTimeMillis());
            editor.commit();

            DatabaseHandler databaseHandler = new DatabaseHandler(context);
            databaseHandler.addEvent(new EventsModel(ssid,appName,PushchampPreferences.SESSION_START,PushchampPreferences.EVENT_TYPE,System.currentTimeMillis(),0,PushchampPreferences.PLATFORM, new JSONObject().toString()));
            databaseHandler.close();
            context.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).edit().putString(PushchampPreferences.SESSION_ID, ssid).apply();

        }


        long sessionStopTime = context.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).getLong(PushchampPreferences.APP_STOP_TIME, 0);

            if(sessionStopTime!=0) {

                /*Check the last time the used app*/

                long sessionInterval = System.currentTimeMillis() - sessionStopTime;
                long diffMinutes = sessionInterval / (60 * 1000) % 60;

                //Check whether time difference is greater than 5 minutes
                if ((TimeUnit.MINUTES.toMillis(diffMinutes) >= TimeUnit.MINUTES.toMillis(PushchampPreferences.APP_SESSION_TIME_IN_MINUTES))) {


                    String previousSessionId = context.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).getString(PushchampPreferences.SESSION_ID, "");
                    String ssid = generateRandomChars(
                            candidateChars, 32);
                    context.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).edit().putString(PushchampPreferences.SESSION_ID, ssid).apply();
                    context.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).edit().putLong(PushchampPreferences.APP_STOP_TIME,System.currentTimeMillis()).commit();

                    long tfsValueFieldEndEvent = TimeUnit.MILLISECONDS.toSeconds((sessionStopTime - context.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).getLong("ts", 0)));

                    SharedPreferences.Editor editor = context.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).edit();
                    editor.putLong("ts", System.currentTimeMillis());
                    editor.commit();

                    DatabaseHandler databaseHandler = new DatabaseHandler(context);
                    databaseHandler.addEvent(new EventsModel(previousSessionId, appName, PushchampPreferences.SESSION_END, PushchampPreferences.EVENT_TYPE, sessionStopTime, tfsValueFieldEndEvent, PushchampPreferences.PLATFORM, new JSONObject().toString()));
                    databaseHandler.addEvent(new EventsModel(ssid, appName, PushchampPreferences.SESSION_START, PushchampPreferences.EVENT_TYPE, System.currentTimeMillis(), 0, PushchampPreferences.PLATFORM, new JSONObject().toString()));
                    databaseHandler.close();



                }

            }


    }

     String generateRandomChars(String candidateChars, int length) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; i++) {
            sb.append(candidateChars.charAt(random.nextInt(candidateChars
                    .length())));
        }

        return sb.toString();
    }


}
