package com.pushchamp.events;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

import com.pushchamp.PushChamp;
import com.pushchamp.PushchampPreferences;
import com.pushchamp.database.DatabaseHandler;
import com.pushchamp.utils.Constants;
import com.pushchamp.utils.StringUtils;
import com.pushchamp.utils.URLConnection;
import com.pushchamp.utils.VersionInfo;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.net.HttpURLConnection;

import javax.net.ssl.HttpsURLConnection;

/**
 * Created by munnaz on 26/12/16.
 */

public class EventApiCall {
    /**
     * Enable Thread to communicate with server
     * @param mContext the InputStream to convert to a String
     * @param subscriptionId
     * @return null
     */
    public void startEventCall(final Context mContext, final String subscriptionId) {
        // Create Inner Thread Class

        final Thread background = new Thread(new Runnable() {

             JSONObject emptyArray = new JSONObject();

            int statusCode;

            // After call for background.start this run method call
            public void run() {
                try {
                    JSONObject deviceJSON = new JSONObject();
                    JSONArray jsonArray = new JSONArray();
                    if (!Thread.currentThread().isInterrupted()) {

                        HttpURLConnection conn = null;
                        DatabaseHandler databaseHandler=new DatabaseHandler(mContext);
                        if (databaseHandler.getEventsCount() > PushchampPreferences.DATABASE_SENT_EVENT_BUFFER) {

                            Cursor cursor = databaseHandler.getEvents();
                            if (cursor.moveToFirst()) {
                                while (cursor.isAfterLast() == false) {

                                    try {

                                        deviceJSON = new JSONObject();
                                        deviceJSON.put("ssid", cursor.getString(cursor.getColumnIndex("ssid")));
                                        deviceJSON.put("sid", subscriptionId);
                                        deviceJSON.put("app", cursor.getString(cursor.getColumnIndex("app")));
                                        deviceJSON.put("ev", cursor.getString(cursor.getColumnIndex("ev")));
                                        deviceJSON.put("ty", cursor.getString(cursor.getColumnIndex("ty")));
                                        deviceJSON.put("ts", cursor.getLong(cursor.getColumnIndex("ts")));
                                        deviceJSON.put("tfs", cursor.getLong(cursor.getColumnIndex("tfs")));
                                        deviceJSON.put("pf", cursor.getString(cursor.getColumnIndex("pf")));

                                        /*Check for custum event tags*/
                                        if ((cursor.getString(cursor.getColumnIndex("et")) == null) || (cursor.getString(cursor.getColumnIndex("pf")).equalsIgnoreCase(""))) {

                                            deviceJSON.put("et", emptyArray);

                                        }
                                        else
                                        {
                                            deviceJSON.put("et",  new JSONObject(cursor.getString(cursor.getColumnIndex("et"))));
                                        }


                                        jsonArray.put(deviceJSON);


                                    } catch (Exception e) {
                                        PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
                                    }


                                    cursor.moveToNext();
                                }
                            }
                            if (cursor != null) {
                                cursor.close();
                            }

                            String message = jsonArray.toString();

                                PushChamp.getLogger().d(TAG+" Send Request", "" + message);

                            databaseHandler.close();
                            String response = null;
                            try {

                                conn=(new URLConnection.Builder()).setApi(VersionInfo.API_LOG_EVENT).setMessageBody(message).build();


                                if(conn!=null) {
                                    conn.connect();


                                    statusCode = conn.getResponseCode();


                                    if (statusCode == HttpsURLConnection.HTTP_OK) {

                                        response = StringUtils.inputStreamToString(
                                                conn.getInputStream());

                                    } else {
                                        response = "";
                                    }

                                }
                                else
                                {
                                    Thread.currentThread().interrupt();
                                }

                            } catch (Exception e) {
                                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
                                Thread.currentThread().interrupt();
                            } finally {

                                if (conn != null)
                                    conn.disconnect();
                            }

                            threadMsg(response);

                        }


                    } else {

                        Thread.currentThread().interrupt();
                        return;
                    }


                } catch (Exception e) {
                    // just end the background thread
                    PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);

                    Thread.currentThread().interrupt();
                } catch (Throwable t) {
                    // just end the background thread
                    PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, t);

                    Thread.currentThread().interrupt();
                }
            }

            private void threadMsg(String msg) {

                if(msg != null) {
                    if (!msg.equals("")) {
                        Message msgObj = handler.obtainMessage();
                        Bundle b = new Bundle();
                        b.putString("message", msg);
                        msgObj.setData(b);
                        handler.sendMessage(msgObj);
                    }
                }
            }

            public static final String TAG = "EventLog";

            // Define the Handler that receives messages from the thread and update the progress
            private final Handler handler = new Handler() {

                public void handleMessage(Message msg) {

                    String result = msg.getData().getString("message");

                        PushChamp.getLogger().d(TAG+"Track Response", "" + result);


                    if ((null != result) || (!result.equals(""))) {

                        // ALERT MESSAGE
                        JSONObject mainObject = null;

                        if (statusCode == 200) {
                            try {
                                mainObject = new JSONObject(result);
                                JSONObject eventObject = mainObject.getJSONObject("data");
                                boolean status = mainObject.optBoolean("status");
                                /*If the api response is success the whole entry in database will be cleared*/
                                DatabaseHandler databaseHandler=new DatabaseHandler(mContext);
                                if (status) {

                                    Cursor cursor = databaseHandler.getEvents();
                                    if (cursor.moveToFirst()) {
                                        while (!cursor.isAfterLast()) {

                                            try {

                                                databaseHandler.deleteEvent(cursor.getString(cursor.getColumnIndex("id")));

                                            } catch (Exception e) {
                                                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
                                            }


                                            cursor.moveToNext();
                                        }
                                    }
                                    if (cursor != null) {
                                        cursor.close();
                                    }
                                    databaseHandler.close();
                                }
                            } catch (JSONException e) {
                                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);

                            }

                        }



                    }

                }
            };

        });
        // Start Thread
        background.start();
    }

}
