package com.pushchamp.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;

import com.pushchamp.PushChamp;

/**
 * Created by rajesh on 15/12/16.
 */

public class DatabaseHandler extends SQLiteOpenHelper {

    public static String TAG="DatabaseHandler";

    // Database Version
    private static final int DATABASE_VERSION = 1;

    // Database Name
    private static final String DATABASE_NAME = "eventsManager";

    // events table name
    private static final String TABLE_EVENTS = "events";

    private static final String KEY_ID = "id";
    private static final String KEY_EVENT = "events";
    private static final String KEY_SSID = "ssid";
//    private static final String KEY_SID = "sid";
    private static final String KEY_APP = "app";
    private static final String KEY_EV = "ev";
    private static final String KEY_TY = "ty";
    private static final String KEY_TS = "ts";
    private static final String KEY_TFS = "tfs";
    private static final String KEY_PF = "pf";
    private static final String KEY_ET = "et";

    public DatabaseHandler(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            setWriteAheadLoggingEnabled(true);
        }
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        String CREATE_EVENTS_TABLE = "CREATE TABLE " + TABLE_EVENTS + "("
                + KEY_ID + " INTEGER PRIMARY KEY,"   + KEY_SSID +  " TEXT,"+KEY_APP + " TEXT,"
                + KEY_EV + " TEXT,"+KEY_TY + " TEXT,"+KEY_TS + " TEXT,"+KEY_TFS + " TEXT,"+ KEY_PF + " TEXT,"+ KEY_ET + " TEXT"
                + ")";

        db.execSQL(CREATE_EVENTS_TABLE);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldversion, int newversion) {
        db.execSQL("DROP TABLE IF EXISTS " + TABLE_EVENTS);

        // Create tables again
        onCreate(db);
    }

    @Override
    public void onConfigure(SQLiteDatabase db) {
        super.onConfigure(db);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB &&
                Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN) {
            db.enableWriteAheadLogging();
        } else {


                PushChamp.getLogger().w(TAG+" EventsModel pending Count","WAL is not supported on API levels below 11.");

        }
    }

    /**
     * All CRUD(Create, Read, Update, Delete) Operations
     */

    // Adding new event
    public void addEvent(EventsModel event) {
        SQLiteDatabase db = this.getWritableDatabase();

        ContentValues values = new ContentValues();
//        values.put(KEY_EVENT, event.getEvent()); // Event

        values.put(KEY_SSID, event.getSsid());
//        values.put(KEY_SID, event.getSid());
        values.put(KEY_APP, event.getApp());
        values.put(KEY_EV, event.getEv());
        values.put(KEY_TY, event.getTy());
        values.put(KEY_TS, event.getTs());
        values.put(KEY_TFS, event.getTfs());
        values.put(KEY_PF, event.getPf());
        if(!(event.getEt().equals("{}"))) {
            values.put(KEY_ET, event.getEt());
        }


        // Inserting Row
//        db.insert(TABLE_EVENTS, null, values);
//        db.close(); // Closing database connection

        long res = db.insertWithOnConflict(TABLE_EVENTS, null,
                values, SQLiteDatabase.CONFLICT_REPLACE);

            PushChamp.getLogger().d(TAG+" EventsModel pending Count", "" + res);

        if (res > 0)
            db.close();
    }

    // Deleting single event
    public void deleteEvent(String  id) {
        SQLiteDatabase db = this.getWritableDatabase();
        db.delete(TABLE_EVENTS, KEY_ID + " = ?",
                new String[] { id });
        db.close();
    }


    // Getting single event
   public String getEvents(int id) {
        SQLiteDatabase db = this.getReadableDatabase();

        Cursor cursor = db.query(TABLE_EVENTS, new String[] { KEY_ID,
                        KEY_EVENT }, KEY_ID + "=?",
                new String[] { String.valueOf(id) }, null, null, null, null);
        if (cursor != null)
            cursor.moveToFirst();

        EventsModel event = new EventsModel(Integer.parseInt(cursor.getString(0)),
                cursor.getString(1),cursor.getString(2),cursor.getString(3),cursor.getString(4),cursor.getLong(5),cursor.getLong(6),cursor.getString(7),cursor.getString(8));
        // return event
        return event.toString();

    }


    public Cursor getEvents() {
        String countQuery = "SELECT  * FROM " + TABLE_EVENTS;
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.rawQuery(countQuery, null);
        // cursor.close();

        // return count
        return cursor;
    }

    // Updating single event
//    public int updateSid(String id, String sid) {
//        SQLiteDatabase db = this.getWritableDatabase();
//
//        ContentValues values = new ContentValues();
//        values.put(KEY_SID, sid);
//
//        // updating row
//        return db.update(TABLE_EVENTS, values, KEY_ID + " = ?",
//                new String[] { id });
//    }


    // Getting single event
//    public String getSid(int id) {
//        String countQuery = "SELECT  * FROM " + TABLE_EVENTS + " WHERE ID="+id;
//
//        SQLiteDatabase db = this.getReadableDatabase();
//        Cursor cursor = db.rawQuery(countQuery, null);
//        if (cursor != null && cursor.moveToFirst()) {
//            return  cursor.getString(cursor.getColumnIndex("sid"));
//        }else {
//            return "";
//        }
//    }


    // Getting events Count
    public int getEventsCount() {
        String countQuery = "SELECT  * FROM " + TABLE_EVENTS;
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.rawQuery(countQuery, null);
        int count = cursor.getCount();
        cursor.close();

        // return count
        return count;
    }

}
