package com.pushchamp;


import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;

import com.pushchamp.database.DatabaseHandler;
import com.pushchamp.database.EventsModel;
import com.pushchamp.events.EventApiCall;
import com.pushchamp.events.EventsApiGenerator;
import com.pushchamp.events.custom.Events;
import com.pushchamp.log.DefaultLogger;
import com.pushchamp.log.Logger;
import com.pushchamp.utils.ConnectionDetector;

import java.util.concurrent.TimeUnit;


/**
 * Created by Ramesh on 26/12/16.
 */

public class PushChamp {

    /*
    * Basic class of pushChamp
    * */

    //Default Logging mode enabled
    static Logger LOGGER = new DefaultLogger();

    static volatile PushChamp singleton;

    public static boolean debug = false;

    private PushchampSubscription pushChampSubscription;

    Context context;

    /*Log Level Options*/
    public static class LOG_LEVEL {
        public static int

                ERROR=Log.ERROR,
                WARN=Log.WARN,
                INFO=Log.INFO,
                DEBUG=Log.DEBUG,
                VERBOSE=Log.VERBOSE;

   }




    /*Enabling debugging during development*/
    public static void setLogEnabled(int logLevel) {
        debug = true;
        LOGGER = new DefaultLogger(logLevel);
    }




    /*Build PushChamp*/
    public static PushChamp enableTrackingWith(Context context) {

        if (singleton == null) {
            synchronized (PushChamp.class) {
                if (singleton == null) {

                    setPushChamp((new PushChamp.Builder(context)).initialize());

                }
            }
        }


        return singleton;
    }


    /*if debugging is enabled get the declared debegger*/
    public static Logger getLogger() {
        return LOGGER;
    }

    /*Check Whether debugging is enabled*/
    public static boolean isDebuggable() {
        return debug;
    }

    /*Starting PushChamp*/
    private static void setPushChamp(PushChamp pushChamp) {
        singleton = pushChamp;
        pushChamp.init();
    }

 
    /*PushChamp init*/
    private void init() {

        pushChampSubscription.register();
        /*registering Activity Lifecycle events*/
        new EventsApiGenerator(this.context).registerEventsActivityLifecycleCallbacks();

    }


    /*Builder class can handle future methods of push champ in one house*/
    public static class Builder {

        private final Context context;
        private DatabaseHandler databaseHandler;
        boolean customEvent = false;
        SharedPreferences sharedPreferences;
        private String appName;


        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            } else {
                this.context = context;

            }
        }

        /*builder for initializing Custom Event*/
        public Builder pushChampCustomEventHandler(Events event, Context context) {


            appName = PushchampPreferences.getAppName(context);


            customEvent = true;
            sharedPreferences = context.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE);

            long currentTime = System.currentTimeMillis();
            long tfsDifferenceInTime = (currentTime - sharedPreferences.getLong("ts", 0))/1000;

            databaseHandler = new DatabaseHandler(context);
            databaseHandler.addEvent(new EventsModel(sharedPreferences.getString(PushchampPreferences.SESSION_ID, ""), appName, event.getCustomType(), PushchampPreferences.EVENT_TYPE, currentTime, tfsDifferenceInTime, PushchampPreferences.PLATFORM, event.getCustomEventData()));
            databaseHandler.close();


            return this;
        }


        public void build() {

            //when custom event added
            if (customEvent == true && sharedPreferences != null) {
                /*check if Subscription occurred if occur go for build EventApiCall to start event method*/
                if (sharedPreferences.getString(PushchampPreferences.SUBSCRIPTION_ID, null) != null) {

                    if (sharedPreferences.getString(PushchampPreferences.SUBSCRIPTION_ID, null).length() > 1) {
                        new EventApiCall().startEventCall(context, sharedPreferences.getString(PushchampPreferences.SUBSCRIPTION_ID, null));
                    }
                }
            }
        }

        /*initializing PushCamp instance*/
        public PushChamp initialize() {
            return new PushChamp(context);
        }


    }

    private PushChamp(Context context) {

        this.context = context;


        if (this.pushChampSubscription == null) {

            this.pushChampSubscription = new PushchampSubscription(context);

        }


    }

}
