/*
 * Decompiled with CFR 0.152.
 */
package com.pushchamp.pushchampsdk;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;
import com.google.android.gms.iid.InstanceID;
import com.pushchamp.pushchampsdk.PushchampWrapper;

public class PushchampRegistrationService
extends IntentService {
    private static final String TAG = PushchampRegistrationService.class.getSimpleName();

    public PushchampRegistrationService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        SharedPreferences sharedPreferences = this.getSharedPreferences("PushchampPrefs", 0);
        try {
            InstanceID instanceID = InstanceID.getInstance((Context)this);
            String token = instanceID.getToken(intent.getStringExtra("SENDER_ID"), "GCM", null);
            Log.i((String)TAG, (String)("GCM Registration Token: " + token));
            this.sendRegistrationToServer(intent.getStringExtra("APP_ID"), token);
            sharedPreferences.edit().putBoolean("sentTokenToServer", true).apply();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"Failed to complete token refresh", (Throwable)e);
            sharedPreferences.edit().putBoolean("sentTokenToServer", false).apply();
        }
    }

    private void sendRegistrationToServer(String app, String token) {
        PushchampWrapper pc = new PushchampWrapper((Context)this, app, token, null, null, null, null);
        pc.execute(new Void[0]);
    }
}

