package com.pushchamp.pushchampsdk;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.TreeMap;

class PushchampWrapper extends AsyncTask<Void, Void, String> {
    private String subscription_id;
    private String pnToken;
    private HashMap<String, String> add_tags;
    private String[] delete_tags;
    private final static String TAG = PushchampWrapper.class.getSimpleName();
    private static String PLATFORM = "android";
    private Context ctx;
    private String app;
    private String[] add_groups;
    private String[] delete_groups;

    public PushchampWrapper(Context ctx, String app, String pnToken, HashMap<String, String> add_tags, String[] delete_tags, String[] add_groups, String[] delete_groups){
        this.ctx = ctx;
        this.app = app;
        this.subscription_id = this.ctx.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).getString(PushchampPreferences.SUBSCRIPTION_ID, null);
        this.pnToken = pnToken;
        this.add_tags = add_tags;
        this.delete_tags = delete_tags;
        this.add_groups = add_groups;
        this.delete_groups = delete_groups;
        Log.i(TAG, "PushchampCall initiated!");
    }

    @Override
    protected String doInBackground(Void... p) {
        TreeMap<String, String> params = new TreeMap<String, String>();

        String android_id = Settings.Secure.getString(ctx.getContentResolver(), Settings.Secure.ANDROID_ID);

        params.put("app", this.app);
        if (this.add_tags!=null){
            //Keys to JSON
            JSONObject add_tags_json = new JSONObject();
            try{
                for(HashMap.Entry<String, String> entry : this.add_tags.entrySet()){
                    add_tags_json.put(entry.getKey(), entry.getValue());
                }
            }catch(Exception e){

            }
            params.put("add_tags", add_tags_json.toString());
        }
        if (this.delete_tags!=null){
            //Array to JSON Array
            JSONArray delete_tags_json = new JSONArray();
            for(int i=0;i<this.delete_tags.length;i++){
                delete_tags_json.put(this.delete_tags[i]);
            }

            params.put("delete_tags", delete_tags_json.toString());
        }
        if (this.subscription_id!=null){
            params.put("subscription_id", this.subscription_id);
        }
        if (this.add_groups!=null){
            //Array to JSON Array
            JSONArray add_groups_json = new JSONArray();
            for(int i=0;i<this.add_groups.length;i++){
                add_groups_json.put(this.add_groups[i]);
            }

            params.put("add_groups", add_groups_json.toString());
        }
        if (this.delete_groups!=null){
            //Array to JSON Array
            JSONArray delete_groups_json = new JSONArray();
            for(int i=0;i<this.delete_groups.length;i++){
                delete_groups_json.put(this.delete_groups[i]);
            }

            params.put("delete_groups", delete_groups_json.toString());
        }
        params.put("platform", PLATFORM);
        params.put("hardware_id", android_id);


        try {
            JSONObject deviceJSON = new JSONObject();
            deviceJSON.put("android_os", System.getProperty("os.version"));
            deviceJSON.put("android_api", Build.VERSION.SDK_INT);
            deviceJSON.put("device", Build.DEVICE);
            deviceJSON.put("model", Build.MODEL);
            deviceJSON.put("product", Build.PRODUCT);
            params.put("other", deviceJSON.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (this.pnToken!=null){
            params.put("notification_token", this.pnToken);
        }

        String response = null;
        URL url;
        try {
            url = new URL("https://www.pushchamp.com/subscribe/");
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setReadTimeout(10000);
            conn.setConnectTimeout(15000);
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);


            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(
                    new OutputStreamWriter(os, "UTF-8"));
            writer.write(getQuery(params));
            writer.flush();
            writer.close();
            os.close();
            conn.connect();
            //Log.i(TAG, "Connection input stream: " + conn.getResponseCode());
            response = getStringFromInputStream(conn.getInputStream());
            //Log.i(TAG, "Response: "+response);
            try{
                JSONObject respJson = new JSONObject(response);
                if (respJson.getString("status").equals("success")){
                    String sid = respJson.getString("subscription_id");
                    this.ctx.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).edit().putString(PushchampPreferences.SUBSCRIPTION_ID, sid).apply();
                }
            }catch (JSONException e){

            }

        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (ProtocolException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    @Override
    protected void onPostExecute(String result) {
        super.onPostExecute(result);
    }

    private String getQuery(TreeMap<String, String> params) throws UnsupportedEncodingException
    {
        StringBuilder result = new StringBuilder();
        boolean first = true;

        for(TreeMap.Entry<String,String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();

            if (first)
                first = false;
            else
                result.append("&");
            result.append(URLEncoder.encode(key, "UTF-8"));
            result.append("=");
            //Log.i(TAG, "Pair = "+ value);
            result.append(URLEncoder.encode(value, "UTF-8"));
        }

        return result.toString();
    }

    protected static String getStringFromInputStream(InputStream is) {
        if (is == null) {
            return null;
        }
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();

        String line;
        try {
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }

        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}