/*
 * Decompiled with CFR 0.152.
 */
package com.pushchamp.pushchampsdk;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;
import com.google.android.gms.common.GoogleApiAvailability;
import com.pushchamp.pushchampsdk.PushchampRegistrationService;
import com.pushchamp.pushchampsdk.PushchampWrapper;
import java.util.HashMap;

public class PushchampSubscription {
    private static final String TAG = PushchampSubscription.class.getSimpleName();
    private String app;
    private Context context;
    private SharedPreferences sharedPrefs;

    public PushchampSubscription(Context ctx, String app) {
        this.context = ctx;
        this.app = app;
        this.sharedPrefs = ctx.getSharedPreferences("PushchampPrefs", 0);
    }

    public void register(String sender_id) {
        if (this.checkPlayServices()) {
            Intent intent = new Intent(this.context, PushchampRegistrationService.class);
            intent.putExtra("SENDER_ID", sender_id);
            intent.putExtra("APP_ID", this.app);
            this.context.startService(intent);
        }
    }

    public void updateTags(HashMap<String, String> add_tags, String[] delete_tags) {
        String subscription_id = this.sharedPrefs.getString("subscription_id", "");
        if (subscription_id == null) {
            Log.e((String)TAG, (String)"Update tag failed: Device not registered");
            return;
        }
        PushchampWrapper pc = new PushchampWrapper(this.context, this.app, null, add_tags, delete_tags);
        pc.execute(new Void[0]);
    }

    public void addGroups(HashMap<String, String> add_groups) {
        String subscription_id = this.sharedPrefs.getString("subscription_id", "");
        if (subscription_id == null) {
            Log.e((String)TAG, (String)"Add groups failed: Device not registered");
            return;
        }
        PushchampWrapper pc = new PushchampWrapper(this.context, this.app, null, null, null);
        pc.execute(new Void[0]);
    }

    private boolean checkPlayServices() {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        int resultCode = apiAvailability.isGooglePlayServicesAvailable(this.context);
        if (resultCode != 0) {
            Log.i((String)TAG, (String)"This device is not supported for GCM.");
            return false;
        }
        return true;
    }
}

