package com.pushchamp.pushchampsdk;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;

import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;

import java.util.HashMap;


public class PushchampSubscription {
    private static final String TAG = PushchampSubscription.class.getSimpleName();
    private String app;
    private Context context;

    private SharedPreferences sharedPrefs;

    public PushchampSubscription(Context ctx, String app){
        this.context = ctx;
        this.app = app;
        sharedPrefs = ctx.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE);
    }

    public void register(String sender_id){
        if (checkPlayServices()) {
            Intent intent = new Intent(this.context, PushchampRegistrationService.class);
            intent.putExtra(PushchampPreferences.SENDER_ID, sender_id);
            intent.putExtra(PushchampPreferences.APP_ID, this.app);
            this.context.startService(intent);
        }
    }

    public void updateTags(HashMap<String, String> add_tags, String[] delete_tags){
        String subscription_id = sharedPrefs.getString(PushchampPreferences.SUBSCRIPTION_ID, "");
        if (subscription_id==null){
            Log.e(TAG, "Update tag failed: Device not registered");
            return;
        }
        PushchampWrapper pc = new PushchampWrapper(context, this.app, null, add_tags, delete_tags);
        pc.execute();
    }

    public void addGroups(HashMap<String, String> add_groups){
        String subscription_id = sharedPrefs.getString(PushchampPreferences.SUBSCRIPTION_ID, "");
        if (subscription_id==null){
            Log.e(TAG, "Add groups failed: Device not registered");
            return;
        }
        PushchampWrapper pc = new PushchampWrapper(context, this.app, null, null, null);
        pc.execute();
    }


    private boolean checkPlayServices() {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        int resultCode = apiAvailability.isGooglePlayServicesAvailable(this.context);
        if (resultCode != ConnectionResult.SUCCESS) {
            Log.i(TAG, "This device is not supported for GCM.");
            return false;
        }
        return true;
    }


}
