package com.pushchamp.pushchampsdk;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;

import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.iid.InstanceID;

public class PushchampRegistrationService extends IntentService {

    private static final String TAG = PushchampRegistrationService.class.getSimpleName();
    public PushchampRegistrationService() {
        super(TAG);
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE);

        try {
            InstanceID instanceID = InstanceID.getInstance(this);
            String token = instanceID.getToken(intent.getStringExtra(PushchampPreferences.SENDER_ID),
                    GoogleCloudMessaging.INSTANCE_ID_SCOPE, null);
            Log.i(TAG, "GCM Registration Token: " + token);
            sendRegistrationToServer(intent.getStringExtra(PushchampPreferences.APP_ID), token);

            sharedPreferences.edit().putBoolean(PushchampPreferences.SENT_TOKEN_TO_SERVER, true).apply();
        } catch (Exception e) {
            Log.d(TAG, "Failed to complete token refresh", e);
            sharedPreferences.edit().putBoolean(PushchampPreferences.SENT_TOKEN_TO_SERVER, false).apply();
        }
        //Intent registrationComplete = new Intent(PushchampPreferences.REGISTRATION_COMPLETE);
        //LocalBroadcastManager.getInstance(this).sendBroadcast(registrationComplete);
    }

    private void sendRegistrationToServer(String app, String token) {
        PushchampWrapper pc = new PushchampWrapper(this, app, token, null, null);
        pc.execute();
    }
}