package com.pushchamp.pushchampsdk;

import android.content.Intent;
import android.os.Bundle;

import com.google.android.gms.gcm.GcmListenerService;

public class PushchampGCMListener extends GcmListenerService {

    private static final String TAG = PushchampGCMListener.class.getSimpleName();

    @Override
    public void onMessageReceived(String from, Bundle data) {
        if(data.getString("mg")==null || data.getString("hd")==null){
            Intent intent = new Intent();
            intent.setAction("com.pushchamp.custom.notification");
            intent.putExtra("data", data);
            sendBroadcast(intent);
        }else{
            PushchampNotification pn = new PushchampNotification(this, data);
            pn.show();
        }
    }
}
