/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.DetailAstImpl;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.grammar.java.JavaLanguageParser;
import com.puppycrawl.tools.checkstyle.grammar.java.JavaLanguageParserBaseVisitor;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;

public final class JavaAstVisitor
extends JavaLanguageParserBaseVisitor<DetailAstImpl> {
    private static final String LEFT_SHIFT = "<<";
    private static final String UNSIGNED_RIGHT_SHIFT = ">>>";
    private static final String RIGHT_SHIFT = ">>";
    private final BufferedTokenStream tokens;

    public JavaAstVisitor(CommonTokenStream tokenStream) {
        this.tokens = tokenStream;
    }

    @Override
    public DetailAstImpl visitCompilationUnit(JavaLanguageParser.CompilationUnitContext ctx) {
        DetailAstImpl compilationUnit;
        boolean isEmptyFile;
        boolean bl = isEmptyFile = ctx.children.size() == 1;
        if (isEmptyFile) {
            compilationUnit = null;
        } else {
            compilationUnit = JavaAstVisitor.createImaginary(1);
            this.processChildren(compilationUnit, ctx.children.subList(0, ctx.children.size() - 1));
        }
        return compilationUnit;
    }

    @Override
    public DetailAstImpl visitPackageDeclaration(JavaLanguageParser.PackageDeclarationContext ctx) {
        DetailAstImpl packageDeclaration = this.create(16, (Token)ctx.LITERAL_PACKAGE().getPayload());
        packageDeclaration.addChild(this.visit((ParseTree)ctx.annotations()));
        packageDeclaration.addChild(this.visit((ParseTree)ctx.qualifiedName()));
        packageDeclaration.addChild(this.create(ctx.SEMI()));
        return packageDeclaration;
    }

    @Override
    public DetailAstImpl visitImportDec(JavaLanguageParser.ImportDecContext ctx) {
        boolean isStarImport;
        DetailAstImpl importRoot = this.create(ctx.start);
        if (ctx.LITERAL_STATIC() != null) {
            importRoot.setType(152);
            importRoot.addChild(this.create(ctx.LITERAL_STATIC()));
        }
        boolean bl = isStarImport = ctx.STAR() != null;
        if (isStarImport) {
            DetailAstImpl dot = this.create(ctx.DOT());
            dot.addChild(this.visit((ParseTree)ctx.qualifiedName()));
            dot.addChild(this.create(ctx.STAR()));
            importRoot.addChild(dot);
        } else {
            importRoot.addChild(this.visit((ParseTree)ctx.qualifiedName()));
        }
        importRoot.addChild(this.create(ctx.SEMI()));
        return importRoot;
    }

    @Override
    public DetailAstImpl visitSingleSemiImport(JavaLanguageParser.SingleSemiImportContext ctx) {
        return this.create(ctx.SEMI());
    }

    @Override
    public DetailAstImpl visitTypeDeclaration(JavaLanguageParser.TypeDeclarationContext ctx) {
        DetailAstImpl typeDeclaration;
        if (ctx.type == null) {
            typeDeclaration = this.create(ctx.semi.get(0));
            ctx.semi.subList(1, ctx.semi.size()).forEach(semi -> JavaAstVisitor.addLastSibling(typeDeclaration, this.create((Token)semi)));
        } else {
            typeDeclaration = this.visit((ParseTree)ctx.type);
        }
        return typeDeclaration;
    }

    @Override
    public DetailAstImpl visitModifier(JavaLanguageParser.ModifierContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitVariableModifier(JavaLanguageParser.VariableModifierContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitClassDeclaration(JavaLanguageParser.ClassDeclarationContext ctx) {
        return this.createTypeDeclaration(ctx, 14, ctx.mods);
    }

    @Override
    public DetailAstImpl visitRecordDeclaration(JavaLanguageParser.RecordDeclarationContext ctx) {
        return this.createTypeDeclaration(ctx, 199, ctx.mods);
    }

    @Override
    public DetailAstImpl visitRecordComponentsList(JavaLanguageParser.RecordComponentsListContext ctx) {
        DetailAstImpl lparen = this.create(ctx.LPAREN());
        if (ctx.recordComponents() == null) {
            JavaAstVisitor.addLastSibling(lparen, JavaAstVisitor.createImaginary(201));
        } else {
            JavaAstVisitor.addLastSibling(lparen, this.visit((ParseTree)ctx.recordComponents()));
        }
        JavaAstVisitor.addLastSibling(lparen, this.create(ctx.RPAREN()));
        return lparen;
    }

    @Override
    public DetailAstImpl visitRecordComponents(JavaLanguageParser.RecordComponentsContext ctx) {
        DetailAstImpl recordComponents = JavaAstVisitor.createImaginary(201);
        this.processChildren(recordComponents, ctx.children);
        return recordComponents;
    }

    @Override
    public DetailAstImpl visitRecordComponent(JavaLanguageParser.RecordComponentContext ctx) {
        DetailAstImpl recordComponent = JavaAstVisitor.createImaginary(202);
        this.processChildren(recordComponent, ctx.children);
        return recordComponent;
    }

    @Override
    public DetailAstImpl visitLastRecordComponent(JavaLanguageParser.LastRecordComponentContext ctx) {
        DetailAstImpl recordComponent = JavaAstVisitor.createImaginary(202);
        this.processChildren(recordComponent, ctx.children);
        return recordComponent;
    }

    @Override
    public DetailAstImpl visitRecordBody(JavaLanguageParser.RecordBodyContext ctx) {
        DetailAstImpl objBlock = JavaAstVisitor.createImaginary(6);
        this.processChildren(objBlock, ctx.children);
        return objBlock;
    }

    @Override
    public DetailAstImpl visitCompactConstructorDeclaration(JavaLanguageParser.CompactConstructorDeclarationContext ctx) {
        DetailAstImpl compactConstructor = JavaAstVisitor.createImaginary(203);
        compactConstructor.addChild(this.createModifiers(ctx.mods));
        compactConstructor.addChild(this.visit((ParseTree)ctx.id()));
        compactConstructor.addChild(this.visit((ParseTree)ctx.constructorBlock()));
        return compactConstructor;
    }

    @Override
    public DetailAstImpl visitClassExtends(JavaLanguageParser.ClassExtendsContext ctx) {
        DetailAstImpl classExtends = this.create(ctx.EXTENDS_CLAUSE());
        classExtends.addChild(this.visit((ParseTree)ctx.type));
        return classExtends;
    }

    @Override
    public DetailAstImpl visitImplementsClause(JavaLanguageParser.ImplementsClauseContext ctx) {
        DetailAstImpl classImplements = this.create(19, (Token)ctx.LITERAL_IMPLEMENTS().getPayload());
        classImplements.addChild(this.visit((ParseTree)ctx.typeList()));
        return classImplements;
    }

    @Override
    public DetailAstImpl visitTypeParameters(JavaLanguageParser.TypeParametersContext ctx) {
        DetailAstImpl typeParameters = JavaAstVisitor.createImaginary(165);
        typeParameters.addChild(this.create(172, (Token)ctx.LT().getPayload()));
        this.processChildren(typeParameters, ctx.children.subList(1, ctx.children.size() - 1));
        typeParameters.addChild(this.create(173, (Token)ctx.GT().getPayload()));
        return typeParameters;
    }

    @Override
    public DetailAstImpl visitTypeParameter(JavaLanguageParser.TypeParameterContext ctx) {
        DetailAstImpl typeParameter = JavaAstVisitor.createImaginary(166);
        this.processChildren(typeParameter, ctx.children);
        return typeParameter;
    }

    @Override
    public DetailAstImpl visitTypeUpperBounds(JavaLanguageParser.TypeUpperBoundsContext ctx) {
        DetailAstImpl typeUpperBounds = this.create(168, (Token)ctx.EXTENDS_CLAUSE().getPayload());
        this.processChildren(typeUpperBounds, ctx.children.subList(1, ctx.children.size()));
        return typeUpperBounds;
    }

    @Override
    public DetailAstImpl visitTypeBound(JavaLanguageParser.TypeBoundContext ctx) {
        DetailAstImpl typeBoundType = this.visit((ParseTree)ctx.typeBoundType(0));
        ListIterator<JavaLanguageParser.TypeBoundTypeContext> typeBoundTypeIterator = ctx.typeBoundType().listIterator(1);
        ctx.BAND().forEach(band -> {
            JavaAstVisitor.addLastSibling(typeBoundType, this.create(174, (Token)band.getPayload()));
            JavaAstVisitor.addLastSibling(typeBoundType, this.visit((ParseTree)typeBoundTypeIterator.next()));
        });
        return typeBoundType;
    }

    @Override
    public DetailAstImpl visitTypeBoundType(JavaLanguageParser.TypeBoundTypeContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitEnumDeclaration(JavaLanguageParser.EnumDeclarationContext ctx) {
        return this.createTypeDeclaration(ctx, 154, ctx.mods);
    }

    @Override
    public DetailAstImpl visitEnumBody(JavaLanguageParser.EnumBodyContext ctx) {
        DetailAstImpl objBlock = JavaAstVisitor.createImaginary(6);
        this.processChildren(objBlock, ctx.children);
        return objBlock;
    }

    @Override
    public DetailAstImpl visitEnumConstants(JavaLanguageParser.EnumConstantsContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitEnumConstant(JavaLanguageParser.EnumConstantContext ctx) {
        DetailAstImpl enumConstant = JavaAstVisitor.createImaginary(155);
        this.processChildren(enumConstant, ctx.children);
        return enumConstant;
    }

    @Override
    public DetailAstImpl visitEnumBodyDeclarations(JavaLanguageParser.EnumBodyDeclarationsContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitInterfaceDeclaration(JavaLanguageParser.InterfaceDeclarationContext ctx) {
        return this.createTypeDeclaration(ctx, 15, ctx.mods);
    }

    @Override
    public DetailAstImpl visitInterfaceExtends(JavaLanguageParser.InterfaceExtendsContext ctx) {
        DetailAstImpl interfaceExtends = this.create(ctx.EXTENDS_CLAUSE());
        interfaceExtends.addChild(this.visit((ParseTree)ctx.typeList()));
        return interfaceExtends;
    }

    @Override
    public DetailAstImpl visitClassBody(JavaLanguageParser.ClassBodyContext ctx) {
        DetailAstImpl objBlock = JavaAstVisitor.createImaginary(6);
        this.processChildren(objBlock, ctx.children);
        return objBlock;
    }

    @Override
    public DetailAstImpl visitInterfaceBody(JavaLanguageParser.InterfaceBodyContext ctx) {
        DetailAstImpl objBlock = JavaAstVisitor.createImaginary(6);
        this.processChildren(objBlock, ctx.children);
        return objBlock;
    }

    @Override
    public DetailAstImpl visitEmptyClass(JavaLanguageParser.EmptyClassContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitClassBlock(JavaLanguageParser.ClassBlockContext ctx) {
        DetailAstImpl classBlock;
        if (ctx.LITERAL_STATIC() == null) {
            classBlock = JavaAstVisitor.createImaginary(11);
        } else {
            classBlock = this.create(12, (Token)ctx.LITERAL_STATIC().getPayload());
            classBlock.setText(TokenUtil.getTokenName(12));
        }
        classBlock.addChild(this.visit((ParseTree)ctx.block()));
        return classBlock;
    }

    @Override
    public DetailAstImpl visitMethodDeclaration(JavaLanguageParser.MethodDeclarationContext ctx) {
        DetailAstImpl methodDef = JavaAstVisitor.createImaginary(9);
        methodDef.addChild(this.createModifiers(ctx.mods));
        this.processChildren(methodDef, ctx.children.stream().filter(child -> !(child instanceof JavaLanguageParser.ArrayDeclaratorContext)).collect(Collectors.toList()));
        DetailAstImpl typeAst = (DetailAstImpl)methodDef.findFirstToken(13);
        ctx.cStyleArrDec.forEach(child -> typeAst.addChild(this.visit((ParseTree)child)));
        return methodDef;
    }

    @Override
    public DetailAstImpl visitMethodBody(JavaLanguageParser.MethodBodyContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitThrowsList(JavaLanguageParser.ThrowsListContext ctx) {
        DetailAstImpl throwsRoot = this.create(ctx.LITERAL_THROWS());
        throwsRoot.addChild(this.visit((ParseTree)ctx.qualifiedNameList()));
        return throwsRoot;
    }

    @Override
    public DetailAstImpl visitConstructorDeclaration(JavaLanguageParser.ConstructorDeclarationContext ctx) {
        DetailAstImpl constructorDeclaration = JavaAstVisitor.createImaginary(8);
        constructorDeclaration.addChild(this.createModifiers(ctx.mods));
        this.processChildren(constructorDeclaration, ctx.children);
        return constructorDeclaration;
    }

    @Override
    public DetailAstImpl visitFieldDeclaration(JavaLanguageParser.FieldDeclarationContext ctx) {
        DetailAstImpl dummyNode = new DetailAstImpl();
        this.processChildren(dummyNode, ctx.children.subList(1, ctx.children.size() - 1));
        dummyNode.getFirstChild().addChild(this.create(ctx.SEMI()));
        return dummyNode.getFirstChild();
    }

    @Override
    public DetailAstImpl visitInterfaceBodyDeclaration(JavaLanguageParser.InterfaceBodyDeclarationContext ctx) {
        DetailAstImpl returnTree = ctx.SEMI() == null ? this.visit((ParseTree)ctx.interfaceMemberDeclaration()) : this.create(ctx.SEMI());
        return returnTree;
    }

    @Override
    public DetailAstImpl visitInterfaceMethodDeclaration(JavaLanguageParser.InterfaceMethodDeclarationContext ctx) {
        DetailAstImpl methodDef = JavaAstVisitor.createImaginary(9);
        methodDef.addChild(this.createModifiers(ctx.mods));
        List children = ctx.children.stream().filter(child -> !(child instanceof JavaLanguageParser.ArrayDeclaratorContext)).collect(Collectors.toList());
        this.processChildren(methodDef, children);
        DetailAstImpl typeAst = (DetailAstImpl)methodDef.findFirstToken(13);
        ctx.cStyleArrDec.forEach(child -> typeAst.addChild(this.visit((ParseTree)child)));
        return methodDef;
    }

    @Override
    public DetailAstImpl visitVariableDeclarators(JavaLanguageParser.VariableDeclaratorsContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitVariableDeclarator(JavaLanguageParser.VariableDeclaratorContext ctx) {
        DetailAstImpl variableDef = JavaAstVisitor.createImaginary(10);
        variableDef.addChild(this.createModifiers(ctx.mods));
        DetailAstImpl type = this.visit((ParseTree)ctx.type);
        variableDef.addChild(type);
        variableDef.addChild(this.visit((ParseTree)ctx.id()));
        ctx.arrayDeclarator().forEach(child -> type.addChild(this.visit((ParseTree)child)));
        if (ctx.ASSIGN() != null) {
            DetailAstImpl assign = this.create(ctx.ASSIGN());
            variableDef.addChild(assign);
            assign.addChild(this.visit((ParseTree)ctx.variableInitializer()));
        }
        return variableDef;
    }

    @Override
    public DetailAstImpl visitVariableDeclaratorId(JavaLanguageParser.VariableDeclaratorIdContext ctx) {
        DetailAstImpl declaratorId;
        DetailAstImpl root = new DetailAstImpl();
        root.addChild(this.createModifiers(ctx.mods));
        DetailAstImpl type = this.visit((ParseTree)ctx.type);
        root.addChild(type);
        if (ctx.LITERAL_THIS() == null) {
            declaratorId = this.visit((ParseTree)ctx.qualifiedName());
        } else if (ctx.DOT() == null) {
            declaratorId = this.create(ctx.LITERAL_THIS());
        } else {
            declaratorId = this.create(ctx.DOT());
            declaratorId.addChild(this.visit((ParseTree)ctx.qualifiedName()));
            declaratorId.addChild(this.create(ctx.LITERAL_THIS()));
        }
        root.addChild(declaratorId);
        ctx.arrayDeclarator().forEach(child -> type.addChild(this.visit((ParseTree)child)));
        return root.getFirstChild();
    }

    @Override
    public DetailAstImpl visitArrayInitializer(JavaLanguageParser.ArrayInitializerContext ctx) {
        DetailAstImpl arrayInitializer = this.create(29, ctx.start);
        this.processChildren(arrayInitializer, ctx.children.subList(1, ctx.children.size()));
        return arrayInitializer;
    }

    @Override
    public DetailAstImpl visitClassOrInterfaceType(JavaLanguageParser.ClassOrInterfaceTypeContext ctx) {
        DetailAstImpl returnTree;
        DetailAstPair currentAST = new DetailAstPair();
        DetailAstPair.addAstChild(currentAST, this.visit((ParseTree)ctx.id()));
        DetailAstPair.addAstChild(currentAST, this.visit((ParseTree)ctx.typeArguments()));
        for (ParserRuleContext parserRuleContext : ctx.extended) {
            DetailAstImpl dot = this.create(parserRuleContext.start);
            DetailAstPair.makeAstRoot(currentAST, dot);
            List childList = parserRuleContext.children.subList(1, parserRuleContext.children.size());
            childList.forEach(child -> DetailAstPair.addAstChild(currentAST, this.visit((ParseTree)child)));
        }
        if (ctx.createImaginaryNode) {
            returnTree = JavaAstVisitor.createImaginary(13);
            returnTree.addChild(currentAST.root);
        } else {
            returnTree = currentAST.root;
        }
        return returnTree;
    }

    @Override
    public DetailAstImpl visitSimpleTypeArgument(JavaLanguageParser.SimpleTypeArgumentContext ctx) {
        DetailAstImpl typeArgument = JavaAstVisitor.createImaginary(164);
        typeArgument.addChild(this.visit((ParseTree)ctx.typeType()));
        return typeArgument;
    }

    @Override
    public DetailAstImpl visitWildCardTypeArgument(JavaLanguageParser.WildCardTypeArgumentContext ctx) {
        DetailAstImpl typeArgument = JavaAstVisitor.createImaginary(164);
        typeArgument.addChild(this.visit((ParseTree)ctx.annotations()));
        typeArgument.addChild(this.create(167, (Token)ctx.QUESTION().getPayload()));
        if (ctx.upperBound != null) {
            DetailAstImpl upperBound = this.create(168, ctx.upperBound);
            upperBound.addChild(this.visit((ParseTree)ctx.typeType()));
            typeArgument.addChild(upperBound);
        } else if (ctx.lowerBound != null) {
            DetailAstImpl lowerBound = this.create(169, ctx.lowerBound);
            lowerBound.addChild(this.visit((ParseTree)ctx.typeType()));
            typeArgument.addChild(lowerBound);
        }
        return typeArgument;
    }

    @Override
    public DetailAstImpl visitQualifiedNameList(JavaLanguageParser.QualifiedNameListContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitFormalParameters(JavaLanguageParser.FormalParametersContext ctx) {
        DetailAstImpl lparen = this.create(ctx.LPAREN());
        if (ctx.formalParameterList() == null) {
            JavaAstVisitor.addLastSibling(lparen, JavaAstVisitor.createImaginary(20));
        } else {
            JavaAstVisitor.addLastSibling(lparen, this.visit((ParseTree)ctx.formalParameterList()));
        }
        JavaAstVisitor.addLastSibling(lparen, this.create(ctx.RPAREN()));
        return lparen;
    }

    @Override
    public DetailAstImpl visitFormalParameterList(JavaLanguageParser.FormalParameterListContext ctx) {
        DetailAstImpl parameters = JavaAstVisitor.createImaginary(20);
        this.processChildren(parameters, ctx.children);
        return parameters;
    }

    @Override
    public DetailAstImpl visitFormalParameter(JavaLanguageParser.FormalParameterContext ctx) {
        DetailAstImpl variableDeclaratorId = this.visitVariableDeclaratorId(ctx.variableDeclaratorId());
        DetailAstImpl parameterDef = JavaAstVisitor.createImaginary(21);
        parameterDef.addChild(variableDeclaratorId);
        return parameterDef;
    }

    @Override
    public DetailAstImpl visitLastFormalParameter(JavaLanguageParser.LastFormalParameterContext ctx) {
        DetailAstImpl parameterDef = JavaAstVisitor.createImaginary(21);
        parameterDef.addChild(this.visit((ParseTree)ctx.variableDeclaratorId()));
        DetailAstImpl ident = (DetailAstImpl)parameterDef.findFirstToken(58);
        ident.addPreviousSibling(this.create(ctx.ELLIPSIS()));
        DetailAstImpl type = (DetailAstImpl)parameterDef.findFirstToken(13);
        type.addChild(this.visit((ParseTree)ctx.annotations()));
        return parameterDef;
    }

    @Override
    public DetailAstImpl visitQualifiedName(JavaLanguageParser.QualifiedNameContext ctx) {
        DetailAstImpl ast = this.visit((ParseTree)ctx.id());
        DetailAstPair currentAst = new DetailAstPair();
        DetailAstPair.addAstChild(currentAst, ast);
        for (ParserRuleContext parserRuleContext : ctx.extended) {
            DetailAstImpl dot = this.create(parserRuleContext.start);
            DetailAstPair.makeAstRoot(currentAst, dot);
            List childList = parserRuleContext.children.subList(1, parserRuleContext.children.size());
            this.processChildren(dot, childList);
        }
        return currentAst.getRoot();
    }

    @Override
    public DetailAstImpl visitLiteral(JavaLanguageParser.LiteralContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitIntegerLiteral(JavaLanguageParser.IntegerLiteralContext ctx) {
        int[] longTypes = new int[]{216, 218, 220, 222};
        int tokenType = TokenUtil.isOfType(ctx.start.getType(), longTypes) ? 141 : 137;
        return this.create(tokenType, ctx.start);
    }

    @Override
    public DetailAstImpl visitFloatLiteral(JavaLanguageParser.FloatLiteralContext ctx) {
        DetailAstImpl floatLiteral = TokenUtil.isOfType(ctx.start.getType(), 193, 195) ? this.create(142, ctx.start) : this.create(140, ctx.start);
        return floatLiteral;
    }

    @Override
    public DetailAstImpl visitTextBlockLiteral(JavaLanguageParser.TextBlockLiteralContext ctx) {
        DetailAstImpl textBlockLiteralBegin = this.create(ctx.TEXT_BLOCK_LITERAL_BEGIN());
        textBlockLiteralBegin.addChild(this.create(ctx.TEXT_BLOCK_CONTENT()));
        textBlockLiteralBegin.addChild(this.create(ctx.TEXT_BLOCK_LITERAL_END()));
        return textBlockLiteralBegin;
    }

    @Override
    public DetailAstImpl visitAnnotations(JavaLanguageParser.AnnotationsContext ctx) {
        DetailAstImpl annotations;
        if (!ctx.createImaginaryNode && ctx.anno.isEmpty()) {
            annotations = null;
        } else {
            annotations = JavaAstVisitor.createImaginary(158);
            this.processChildren(annotations, ctx.anno);
        }
        return annotations;
    }

    @Override
    public DetailAstImpl visitAnnotation(JavaLanguageParser.AnnotationContext ctx) {
        DetailAstImpl annotation = JavaAstVisitor.createImaginary(159);
        this.processChildren(annotation, ctx.children);
        return annotation;
    }

    @Override
    public DetailAstImpl visitElementValuePairs(JavaLanguageParser.ElementValuePairsContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitElementValuePair(JavaLanguageParser.ElementValuePairContext ctx) {
        DetailAstImpl elementValuePair = JavaAstVisitor.createImaginary(160);
        this.processChildren(elementValuePair, ctx.children);
        return elementValuePair;
    }

    @Override
    public DetailAstImpl visitElementValue(JavaLanguageParser.ElementValueContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitElementValueArrayInitializer(JavaLanguageParser.ElementValueArrayInitializerContext ctx) {
        DetailAstImpl arrayInit = this.create(162, (Token)ctx.LCURLY().getPayload());
        this.processChildren(arrayInit, ctx.children.subList(1, ctx.children.size()));
        return arrayInit;
    }

    @Override
    public DetailAstImpl visitAnnotationTypeDeclaration(JavaLanguageParser.AnnotationTypeDeclarationContext ctx) {
        return this.createTypeDeclaration(ctx, 157, ctx.mods);
    }

    @Override
    public DetailAstImpl visitAnnotationTypeBody(JavaLanguageParser.AnnotationTypeBodyContext ctx) {
        DetailAstImpl objBlock = JavaAstVisitor.createImaginary(6);
        this.processChildren(objBlock, ctx.children);
        return objBlock;
    }

    @Override
    public DetailAstImpl visitAnnotationTypeElementDeclaration(JavaLanguageParser.AnnotationTypeElementDeclarationContext ctx) {
        DetailAstImpl returnTree = ctx.SEMI() == null ? this.visit((ParseTree)ctx.annotationTypeElementRest()) : this.create(ctx.SEMI());
        return returnTree;
    }

    @Override
    public DetailAstImpl visitAnnotationField(JavaLanguageParser.AnnotationFieldContext ctx) {
        DetailAstImpl dummyNode = new DetailAstImpl();
        this.processChildren(dummyNode, Collections.singletonList(ctx.children.get(1)));
        dummyNode.getFirstChild().addChild(this.create(ctx.SEMI()));
        return dummyNode.getFirstChild();
    }

    @Override
    public DetailAstImpl visitAnnotationType(JavaLanguageParser.AnnotationTypeContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitAnnotationMethodRest(JavaLanguageParser.AnnotationMethodRestContext ctx) {
        DetailAstImpl annotationFieldDef = JavaAstVisitor.createImaginary(161);
        annotationFieldDef.addChild(this.createModifiers(ctx.mods));
        annotationFieldDef.addChild(this.visit((ParseTree)ctx.type));
        this.processChildren(annotationFieldDef, ctx.children.stream().filter(child -> !(child instanceof JavaLanguageParser.ArrayDeclaratorContext)).collect(Collectors.toList()));
        DetailAstImpl typeAst = (DetailAstImpl)annotationFieldDef.findFirstToken(13);
        ctx.cStyleArrDec.forEach(child -> typeAst.addChild(this.visit((ParseTree)child)));
        return annotationFieldDef;
    }

    @Override
    public DetailAstImpl visitDefaultValue(JavaLanguageParser.DefaultValueContext ctx) {
        DetailAstImpl defaultValue = this.create(ctx.LITERAL_DEFAULT());
        defaultValue.addChild(this.visit((ParseTree)ctx.elementValue()));
        return defaultValue;
    }

    @Override
    public DetailAstImpl visitConstructorBlock(JavaLanguageParser.ConstructorBlockContext ctx) {
        DetailAstImpl slist = this.create(7, ctx.start);
        this.processChildren(slist, ctx.children.subList(1, ctx.children.size()));
        return slist;
    }

    @Override
    public DetailAstImpl visitExplicitCtorCall(JavaLanguageParser.ExplicitCtorCallContext ctx) {
        DetailAstImpl root = ctx.LITERAL_THIS() == null ? this.create(42, (Token)ctx.LITERAL_SUPER().getPayload()) : this.create(43, (Token)ctx.LITERAL_THIS().getPayload());
        root.addChild(this.visit((ParseTree)ctx.typeArguments()));
        root.addChild(this.visit((ParseTree)ctx.arguments()));
        root.addChild(this.create(ctx.SEMI()));
        return root;
    }

    @Override
    public DetailAstImpl visitPrimaryCtorCall(JavaLanguageParser.PrimaryCtorCallContext ctx) {
        DetailAstImpl primaryCtorCall = this.create(42, (Token)ctx.LITERAL_SUPER().getPayload());
        this.processChildren(primaryCtorCall, ctx.children.stream().filter(child -> !child.equals(ctx.LITERAL_SUPER())).collect(Collectors.toList()));
        return primaryCtorCall;
    }

    @Override
    public DetailAstImpl visitBlock(JavaLanguageParser.BlockContext ctx) {
        DetailAstImpl slist = this.create(7, ctx.start);
        this.processChildren(slist, ctx.children.subList(1, ctx.children.size()));
        return slist;
    }

    @Override
    public DetailAstImpl visitLocalVar(JavaLanguageParser.LocalVarContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitBlockStat(JavaLanguageParser.BlockStatContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitAssertExp(JavaLanguageParser.AssertExpContext ctx) {
        DetailAstImpl assertExp = this.create(ctx.ASSERT());
        this.processChildren(assertExp, ctx.children.subList(1, ctx.children.size()));
        return assertExp;
    }

    @Override
    public DetailAstImpl visitIfStat(JavaLanguageParser.IfStatContext ctx) {
        DetailAstImpl ifStat = this.create(ctx.LITERAL_IF());
        this.processChildren(ifStat, ctx.children.subList(1, ctx.children.size()));
        return ifStat;
    }

    @Override
    public DetailAstImpl visitForStat(JavaLanguageParser.ForStatContext ctx) {
        DetailAstImpl forInit = this.create(ctx.start);
        this.processChildren(forInit, ctx.children.subList(1, ctx.children.size()));
        return forInit;
    }

    @Override
    public DetailAstImpl visitWhileStat(JavaLanguageParser.WhileStatContext ctx) {
        DetailAstImpl whileStatement = this.create(ctx.start);
        this.processChildren(whileStatement, ctx.children.subList(1, ctx.children.size()));
        return whileStatement;
    }

    @Override
    public DetailAstImpl visitDoStat(JavaLanguageParser.DoStatContext ctx) {
        DetailAstImpl doStatement = this.create(ctx.start);
        doStatement.addChild(this.visit((ParseTree)ctx.statement()));
        doStatement.addChild(this.create(175, (Token)ctx.LITERAL_WHILE().getPayload()));
        doStatement.addChild(this.visit((ParseTree)ctx.parExpression()));
        doStatement.addChild(this.create(ctx.SEMI()));
        return doStatement;
    }

    @Override
    public DetailAstImpl visitTryStat(JavaLanguageParser.TryStatContext ctx) {
        DetailAstImpl tryStat = this.create(ctx.start);
        this.processChildren(tryStat, ctx.children.subList(1, ctx.children.size()));
        return tryStat;
    }

    @Override
    public DetailAstImpl visitTryWithResourceStat(JavaLanguageParser.TryWithResourceStatContext ctx) {
        DetailAstImpl tryWithResources = this.create(ctx.LITERAL_TRY());
        this.processChildren(tryWithResources, ctx.children.subList(1, ctx.children.size()));
        return tryWithResources;
    }

    @Override
    public DetailAstImpl visitYieldStat(JavaLanguageParser.YieldStatContext ctx) {
        DetailAstImpl yieldParent = this.create(ctx.LITERAL_YIELD());
        this.processChildren(yieldParent, ctx.children.subList(1, ctx.children.size()));
        return yieldParent;
    }

    @Override
    public DetailAstImpl visitSyncStat(JavaLanguageParser.SyncStatContext ctx) {
        DetailAstImpl syncStatement = this.create(ctx.start);
        this.processChildren(syncStatement, ctx.children.subList(1, ctx.children.size()));
        return syncStatement;
    }

    @Override
    public DetailAstImpl visitReturnStat(JavaLanguageParser.ReturnStatContext ctx) {
        DetailAstImpl returnStat = this.create(ctx.LITERAL_RETURN());
        this.processChildren(returnStat, ctx.children.subList(1, ctx.children.size()));
        return returnStat;
    }

    @Override
    public DetailAstImpl visitThrowStat(JavaLanguageParser.ThrowStatContext ctx) {
        DetailAstImpl throwStat = this.create(ctx.LITERAL_THROW());
        this.processChildren(throwStat, ctx.children.subList(1, ctx.children.size()));
        return throwStat;
    }

    @Override
    public DetailAstImpl visitBreakStat(JavaLanguageParser.BreakStatContext ctx) {
        DetailAstImpl literalBreak = this.create(ctx.LITERAL_BREAK());
        this.processChildren(literalBreak, ctx.children.subList(1, ctx.children.size()));
        return literalBreak;
    }

    @Override
    public DetailAstImpl visitContinueStat(JavaLanguageParser.ContinueStatContext ctx) {
        DetailAstImpl continueStat = this.create(ctx.LITERAL_CONTINUE());
        this.processChildren(continueStat, ctx.children.subList(1, ctx.children.size()));
        return continueStat;
    }

    @Override
    public DetailAstImpl visitEmptyStat(JavaLanguageParser.EmptyStatContext ctx) {
        return this.create(38, ctx.start);
    }

    @Override
    public DetailAstImpl visitExpStat(JavaLanguageParser.ExpStatContext ctx) {
        DetailAstImpl expStatRoot = this.visit((ParseTree)ctx.statementExpression);
        JavaAstVisitor.addLastSibling(expStatRoot, this.create(ctx.SEMI()));
        return expStatRoot;
    }

    @Override
    public DetailAstImpl visitLabelStat(JavaLanguageParser.LabelStatContext ctx) {
        DetailAstImpl labelStat = this.create(22, (Token)ctx.COLON().getPayload());
        labelStat.addChild(this.visit((ParseTree)ctx.id()));
        labelStat.addChild(this.visit((ParseTree)ctx.statement()));
        return labelStat;
    }

    @Override
    public DetailAstImpl visitSwitchExpressionOrStatement(JavaLanguageParser.SwitchExpressionOrStatementContext ctx) {
        DetailAstImpl switchStat = this.create(ctx.LITERAL_SWITCH());
        switchStat.addChild(this.visit((ParseTree)ctx.parExpression()));
        switchStat.addChild(this.create(ctx.LCURLY()));
        switchStat.addChild(this.visit((ParseTree)ctx.switchBlock()));
        switchStat.addChild(this.create(ctx.RCURLY()));
        return switchStat;
    }

    @Override
    public DetailAstImpl visitSwitchRules(JavaLanguageParser.SwitchRulesContext ctx) {
        DetailAstImpl dummyRoot = new DetailAstImpl();
        ctx.switchLabeledRule().forEach(switchLabeledRuleContext -> {
            DetailAstImpl switchRule = this.visit((ParseTree)switchLabeledRuleContext);
            DetailAstImpl switchRuleParent = JavaAstVisitor.createImaginary(208);
            switchRuleParent.addChild(switchRule);
            dummyRoot.addChild(switchRuleParent);
        });
        return dummyRoot.getFirstChild();
    }

    @Override
    public DetailAstImpl visitSwitchBlocks(JavaLanguageParser.SwitchBlocksContext ctx) {
        DetailAstImpl dummyRoot = new DetailAstImpl();
        ctx.groups.forEach(group -> dummyRoot.addChild(this.visit((ParseTree)group)));
        if (!ctx.emptyLabels.isEmpty()) {
            DetailAstImpl emptyLabelParent = JavaAstVisitor.createImaginary(33);
            ctx.emptyLabels.forEach(label -> emptyLabelParent.addChild(this.visit((ParseTree)label)));
            dummyRoot.addChild(emptyLabelParent);
        }
        return dummyRoot.getFirstChild();
    }

    @Override
    public DetailAstImpl visitSwitchLabeledExpression(JavaLanguageParser.SwitchLabeledExpressionContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitSwitchLabeledBlock(JavaLanguageParser.SwitchLabeledBlockContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitSwitchLabeledThrow(JavaLanguageParser.SwitchLabeledThrowContext ctx) {
        DetailAstImpl switchLabel = this.visit((ParseTree)ctx.switchLabel());
        JavaAstVisitor.addLastSibling(switchLabel, this.create(ctx.LAMBDA()));
        DetailAstImpl literalThrow = this.create(ctx.LITERAL_THROW());
        literalThrow.addChild(this.visit((ParseTree)ctx.expression()));
        literalThrow.addChild(this.create(ctx.SEMI()));
        JavaAstVisitor.addLastSibling(switchLabel, literalThrow);
        return switchLabel;
    }

    @Override
    public DetailAstImpl visitElseStat(JavaLanguageParser.ElseStatContext ctx) {
        DetailAstImpl elseStat = this.create(ctx.LITERAL_ELSE());
        this.processChildren(elseStat, ctx.children.subList(1, ctx.children.size()));
        return elseStat;
    }

    @Override
    public DetailAstImpl visitCatchClause(JavaLanguageParser.CatchClauseContext ctx) {
        DetailAstImpl catchClause = this.create(96, (Token)ctx.LITERAL_CATCH().getPayload());
        this.processChildren(catchClause, ctx.children.subList(1, ctx.children.size()));
        return catchClause;
    }

    @Override
    public DetailAstImpl visitCatchParameter(JavaLanguageParser.CatchParameterContext ctx) {
        DetailAstImpl catchParameterDef = JavaAstVisitor.createImaginary(21);
        catchParameterDef.addChild(this.createModifiers(ctx.mods));
        this.processChildren(catchParameterDef, ctx.children.stream().filter(child -> !(child instanceof JavaLanguageParser.VariableModifierContext)).collect(Collectors.toList()));
        return catchParameterDef;
    }

    @Override
    public DetailAstImpl visitCatchType(JavaLanguageParser.CatchTypeContext ctx) {
        DetailAstImpl type = JavaAstVisitor.createImaginary(13);
        this.processChildren(type, ctx.children);
        return type;
    }

    @Override
    public DetailAstImpl visitFinallyBlock(JavaLanguageParser.FinallyBlockContext ctx) {
        DetailAstImpl finallyBlock = this.create(ctx.LITERAL_FINALLY());
        this.processChildren(finallyBlock, ctx.children.subList(1, ctx.children.size()));
        return finallyBlock;
    }

    @Override
    public DetailAstImpl visitResourceSpecification(JavaLanguageParser.ResourceSpecificationContext ctx) {
        DetailAstImpl resourceSpecification = JavaAstVisitor.createImaginary(176);
        this.processChildren(resourceSpecification, ctx.children);
        return resourceSpecification;
    }

    @Override
    public DetailAstImpl visitResources(JavaLanguageParser.ResourcesContext ctx) {
        DetailAstImpl firstResource = this.visit((ParseTree)ctx.resource(0));
        DetailAstImpl resources = JavaAstVisitor.createImaginary(177);
        resources.addChild(firstResource);
        this.processChildren(resources, ctx.children.subList(1, ctx.children.size()));
        return resources;
    }

    @Override
    public DetailAstImpl visitResourceDeclaration(JavaLanguageParser.ResourceDeclarationContext ctx) {
        DetailAstImpl resource = JavaAstVisitor.createImaginary(178);
        resource.addChild(this.visit((ParseTree)ctx.variableDeclaratorId()));
        DetailAstImpl assign = this.create(ctx.ASSIGN());
        resource.addChild(assign);
        assign.addChild(this.visit((ParseTree)ctx.expression()));
        return resource;
    }

    @Override
    public DetailAstImpl visitVariableAccess(JavaLanguageParser.VariableAccessContext ctx) {
        DetailAstImpl resource;
        if (ctx.accessList.isEmpty()) {
            resource = JavaAstVisitor.createImaginary(178);
            resource.addChild(this.visit((ParseTree)ctx.id()));
        } else {
            DetailAstPair currentAst = new DetailAstPair();
            ctx.accessList.forEach(fieldAccess -> {
                DetailAstPair.addAstChild(currentAst, this.visit((ParseTree)fieldAccess.expr()));
                DetailAstPair.makeAstRoot(currentAst, this.create(fieldAccess.DOT()));
            });
            resource = JavaAstVisitor.createImaginary(178);
            resource.addChild(currentAst.root);
            if (ctx.LITERAL_THIS() == null) {
                resource.getFirstChild().addChild(this.visit((ParseTree)ctx.id()));
            } else {
                resource.getFirstChild().addChild(this.create(ctx.LITERAL_THIS()));
            }
        }
        return resource;
    }

    @Override
    public DetailAstImpl visitSwitchBlockStatementGroup(JavaLanguageParser.SwitchBlockStatementGroupContext ctx) {
        DetailAstImpl caseGroup = JavaAstVisitor.createImaginary(33);
        this.processChildren(caseGroup, ctx.switchLabel());
        DetailAstImpl sList = JavaAstVisitor.createImaginary(7);
        this.processChildren(sList, ctx.slists);
        caseGroup.addChild(sList);
        return caseGroup;
    }

    @Override
    public DetailAstImpl visitCaseLabel(JavaLanguageParser.CaseLabelContext ctx) {
        DetailAstImpl caseLabel = this.create(ctx.LITERAL_CASE());
        this.processChildren(caseLabel, ctx.children.subList(1, ctx.children.size()));
        return caseLabel;
    }

    @Override
    public DetailAstImpl visitDefaultLabel(JavaLanguageParser.DefaultLabelContext ctx) {
        DetailAstImpl defaultLabel = this.create(ctx.LITERAL_DEFAULT());
        if (ctx.COLON() != null) {
            defaultLabel.addChild(this.create(ctx.COLON()));
        }
        return defaultLabel;
    }

    @Override
    public DetailAstImpl visitCaseConstants(JavaLanguageParser.CaseConstantsContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitCaseConstant(JavaLanguageParser.CaseConstantContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitEnhancedFor(JavaLanguageParser.EnhancedForContext ctx) {
        DetailAstImpl leftParen = this.create(ctx.LPAREN());
        DetailAstImpl enhancedForControl = this.visit((ParseTree)ctx.enhancedForControl());
        DetailAstImpl forEachClause = JavaAstVisitor.createImaginary(156);
        forEachClause.addChild(enhancedForControl);
        JavaAstVisitor.addLastSibling(leftParen, forEachClause);
        JavaAstVisitor.addLastSibling(leftParen, this.create(ctx.RPAREN()));
        return leftParen;
    }

    @Override
    public DetailAstImpl visitForFor(JavaLanguageParser.ForForContext ctx) {
        DetailAstImpl dummyRoot = new DetailAstImpl();
        dummyRoot.addChild(this.create(ctx.LPAREN()));
        if (ctx.forInit() == null) {
            DetailAstImpl imaginaryForInitParent = JavaAstVisitor.createImaginary(35);
            dummyRoot.addChild(imaginaryForInitParent);
        } else {
            dummyRoot.addChild(this.visit((ParseTree)ctx.forInit()));
        }
        dummyRoot.addChild(this.create(ctx.SEMI(0)));
        DetailAstImpl forCondParent = JavaAstVisitor.createImaginary(36);
        forCondParent.addChild(this.visit((ParseTree)ctx.forCond));
        dummyRoot.addChild(forCondParent);
        dummyRoot.addChild(this.create(ctx.SEMI(1)));
        DetailAstImpl forItParent = JavaAstVisitor.createImaginary(37);
        forItParent.addChild(this.visit((ParseTree)ctx.forUpdate));
        dummyRoot.addChild(forItParent);
        dummyRoot.addChild(this.create(ctx.RPAREN()));
        return dummyRoot.getFirstChild();
    }

    @Override
    public DetailAstImpl visitForInit(JavaLanguageParser.ForInitContext ctx) {
        DetailAstImpl forInit = JavaAstVisitor.createImaginary(35);
        this.processChildren(forInit, ctx.children);
        return forInit;
    }

    @Override
    public DetailAstImpl visitEnhancedForControl(JavaLanguageParser.EnhancedForControlContext ctx) {
        DetailAstImpl variableDeclaratorId = this.visit((ParseTree)ctx.variableDeclaratorId());
        DetailAstImpl variableDef = JavaAstVisitor.createImaginary(10);
        variableDef.addChild(variableDeclaratorId);
        JavaAstVisitor.addLastSibling(variableDef, this.create(ctx.COLON()));
        JavaAstVisitor.addLastSibling(variableDef, this.visit((ParseTree)ctx.expression()));
        return variableDef;
    }

    @Override
    public DetailAstImpl visitParExpression(JavaLanguageParser.ParExpressionContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitExpressionList(JavaLanguageParser.ExpressionListContext ctx) {
        DetailAstImpl elist = JavaAstVisitor.createImaginary(34);
        this.processChildren(elist, ctx.children);
        return elist;
    }

    @Override
    public DetailAstImpl visitExpression(JavaLanguageParser.ExpressionContext ctx) {
        DetailAstImpl expression = this.visit((ParseTree)ctx.expr());
        DetailAstImpl exprRoot = JavaAstVisitor.createImaginary(28);
        exprRoot.addChild(expression);
        int[] expressionsWithNoExprRoot = new int[]{43, 42, 181};
        if (TokenUtil.isOfType(expression, expressionsWithNoExprRoot)) {
            exprRoot = exprRoot.getFirstChild();
        }
        return exprRoot;
    }

    @Override
    public DetailAstImpl visitRefOp(JavaLanguageParser.RefOpContext ctx) {
        DetailAstImpl bop = this.create(ctx.bop);
        DetailAstImpl leftChild = this.visit((ParseTree)ctx.expr());
        DetailAstImpl rightChild = this.create(58, ctx.stop);
        bop.addChild(leftChild);
        bop.addChild(rightChild);
        return bop;
    }

    @Override
    public DetailAstImpl visitSuperExp(JavaLanguageParser.SuperExpContext ctx) {
        DetailAstImpl bop = this.create(ctx.bop);
        bop.addChild(this.visit((ParseTree)ctx.expr()));
        bop.addChild(this.create(ctx.LITERAL_SUPER()));
        DetailAstImpl superSuffixParent = this.visit((ParseTree)ctx.superSuffix());
        if (superSuffixParent == null) {
            superSuffixParent = bop;
        } else {
            DetailAstImpl firstChild = superSuffixParent.getFirstChild();
            while (firstChild.getFirstChild() != null) {
                firstChild = firstChild.getFirstChild();
            }
            firstChild.addPreviousSibling(bop);
        }
        return superSuffixParent;
    }

    @Override
    public DetailAstImpl visitInstanceOfExp(JavaLanguageParser.InstanceOfExpContext ctx) {
        DetailAstImpl patternDef;
        DetailAstImpl literalInstanceOf = this.create(ctx.LITERAL_INSTANCEOF());
        literalInstanceOf.addChild(this.visit((ParseTree)ctx.expr()));
        ParseTree patternOrType = ctx.getChild(2);
        if (patternOrType instanceof JavaLanguageParser.ParenPatternContext) {
            patternDef = JavaAstVisitor.createImaginary(213);
            patternDef.addChild(this.visit(patternOrType));
        } else {
            patternDef = this.visit(patternOrType);
        }
        literalInstanceOf.addChild(patternDef);
        return literalInstanceOf;
    }

    @Override
    public DetailAstImpl visitBitShift(JavaLanguageParser.BitShiftContext ctx) {
        DetailAstImpl shiftOperation;
        if (ctx.LT().size() == LEFT_SHIFT.length()) {
            shiftOperation = this.create(122, (Token)ctx.LT(0).getPayload());
            shiftOperation.setText(LEFT_SHIFT);
        } else if (ctx.GT().size() == UNSIGNED_RIGHT_SHIFT.length()) {
            shiftOperation = this.create(124, (Token)ctx.GT(0).getPayload());
            shiftOperation.setText(UNSIGNED_RIGHT_SHIFT);
        } else {
            shiftOperation = this.create(123, (Token)ctx.GT(0).getPayload());
            shiftOperation.setText(RIGHT_SHIFT);
        }
        shiftOperation.addChild(this.visit((ParseTree)ctx.expr(0)));
        shiftOperation.addChild(this.visit((ParseTree)ctx.expr(1)));
        return shiftOperation;
    }

    @Override
    public DetailAstImpl visitNewExp(JavaLanguageParser.NewExpContext ctx) {
        DetailAstImpl newExp = this.create(ctx.LITERAL_NEW());
        this.processChildren(newExp, ctx.children.subList(1, ctx.children.size()));
        return newExp;
    }

    @Override
    public DetailAstImpl visitPrefix(JavaLanguageParser.PrefixContext ctx) {
        int tokenType;
        switch (ctx.prefix.getType()) {
            case 125: {
                tokenType = 32;
                break;
            }
            case 126: {
                tokenType = 31;
                break;
            }
            default: {
                tokenType = ctx.prefix.getType();
            }
        }
        DetailAstImpl prefix = this.create(tokenType, ctx.prefix);
        prefix.addChild(this.visit((ParseTree)ctx.expr()));
        return prefix;
    }

    @Override
    public DetailAstImpl visitCastExp(JavaLanguageParser.CastExpContext ctx) {
        DetailAstImpl cast = this.create(23, (Token)ctx.LPAREN().getPayload());
        this.processChildren(cast, ctx.children.subList(1, ctx.children.size()));
        return cast;
    }

    @Override
    public DetailAstImpl visitIndexOp(JavaLanguageParser.IndexOpContext ctx) {
        DetailAstImpl indexOp = this.create(24, (Token)ctx.LBRACK().getPayload());
        indexOp.addChild(this.visit((ParseTree)ctx.expr(0)));
        DetailAstImpl expr = this.visit((ParseTree)ctx.expr(1));
        DetailAstImpl imaginaryExpr = JavaAstVisitor.createImaginary(28);
        imaginaryExpr.addChild(expr);
        indexOp.addChild(imaginaryExpr);
        indexOp.addChild(this.create(ctx.RBRACK()));
        return indexOp;
    }

    @Override
    public DetailAstImpl visitInvOp(JavaLanguageParser.InvOpContext ctx) {
        DetailAstPair currentAst = new DetailAstPair();
        DetailAstImpl returnAst = this.visit((ParseTree)ctx.expr());
        DetailAstPair.addAstChild(currentAst, returnAst);
        DetailAstPair.makeAstRoot(currentAst, this.create(ctx.bop));
        DetailAstPair.addAstChild(currentAst, this.visit((ParseTree)ctx.nonWildcardTypeArguments()));
        DetailAstPair.addAstChild(currentAst, this.visit((ParseTree)ctx.id()));
        DetailAstImpl lparen = this.create(27, (Token)ctx.LPAREN().getPayload());
        DetailAstPair.makeAstRoot(currentAst, lparen);
        DetailAstImpl expressionList = Optional.ofNullable(this.visit((ParseTree)ctx.expressionList())).orElseGet(() -> JavaAstVisitor.createImaginary(34));
        DetailAstPair.addAstChild(currentAst, expressionList);
        DetailAstPair.addAstChild(currentAst, this.create(ctx.RPAREN()));
        return currentAst.root;
    }

    @Override
    public DetailAstImpl visitInitExp(JavaLanguageParser.InitExpContext ctx) {
        DetailAstImpl dot = this.create(ctx.bop);
        dot.addChild(this.visit((ParseTree)ctx.expr()));
        DetailAstImpl literalNew = this.create(ctx.LITERAL_NEW());
        literalNew.addChild(this.visit((ParseTree)ctx.nonWildcardTypeArguments()));
        literalNew.addChild(this.visit((ParseTree)ctx.innerCreator()));
        dot.addChild(literalNew);
        return dot;
    }

    @Override
    public DetailAstImpl visitSimpleMethodCall(JavaLanguageParser.SimpleMethodCallContext ctx) {
        DetailAstImpl methodCall = this.create(27, (Token)ctx.LPAREN().getPayload());
        methodCall.addChild(this.visit((ParseTree)ctx.id()));
        DetailAstImpl expressionList = Optional.ofNullable(this.visit((ParseTree)ctx.expressionList())).orElseGet(() -> JavaAstVisitor.createImaginary(34));
        methodCall.addChild(expressionList);
        methodCall.addChild(this.create((Token)ctx.RPAREN().getPayload()));
        return methodCall;
    }

    @Override
    public DetailAstImpl visitLambdaExp(JavaLanguageParser.LambdaExpContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitThisExp(JavaLanguageParser.ThisExpContext ctx) {
        DetailAstImpl bop = this.create(ctx.bop);
        bop.addChild(this.visit((ParseTree)ctx.expr()));
        bop.addChild(this.create(ctx.LITERAL_THIS()));
        return bop;
    }

    @Override
    public DetailAstImpl visitPrimaryExp(JavaLanguageParser.PrimaryExpContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitPostfix(JavaLanguageParser.PostfixContext ctx) {
        DetailAstImpl postfix = ctx.postfix.getType() == 129 ? this.create(25, ctx.postfix) : this.create(26, ctx.postfix);
        postfix.addChild(this.visit((ParseTree)ctx.expr()));
        return postfix;
    }

    @Override
    public DetailAstImpl visitMethodRef(JavaLanguageParser.MethodRefContext ctx) {
        DetailAstImpl doubleColon = this.create(180, (Token)ctx.DOUBLE_COLON().getPayload());
        List children = ctx.children.stream().filter(child -> !child.equals(ctx.DOUBLE_COLON())).collect(Collectors.toList());
        this.processChildren(doubleColon, children);
        return doubleColon;
    }

    @Override
    public DetailAstImpl visitTernaryOp(JavaLanguageParser.TernaryOpContext ctx) {
        DetailAstImpl root = this.create(ctx.QUESTION());
        this.processChildren(root, ctx.children.stream().filter(child -> !child.equals(ctx.QUESTION())).collect(Collectors.toList()));
        return root;
    }

    @Override
    public DetailAstImpl visitBinOp(JavaLanguageParser.BinOpContext ctx) {
        DetailAstImpl bop = this.create(ctx.bop);
        ArrayList<JavaLanguageParser.BinOpContext> binOpList = new ArrayList<JavaLanguageParser.BinOpContext>();
        JavaLanguageParser.ExprContext firstExpression = ctx.expr(0);
        while (firstExpression instanceof JavaLanguageParser.BinOpContext) {
            binOpList.add((JavaLanguageParser.BinOpContext)firstExpression);
            firstExpression = ((JavaLanguageParser.BinOpContext)firstExpression).expr(0);
        }
        if (binOpList.isEmpty()) {
            DetailAstImpl leftChild = this.visit((ParseTree)ctx.children.get(0));
            bop.addChild(leftChild);
        } else {
            Queue descendantList = binOpList.parallelStream().map(this::getInnerBopAst).collect(Collectors.toCollection(ConcurrentLinkedQueue::new));
            bop.addChild((DetailAST)descendantList.poll());
            DetailAstImpl pointer = bop.getFirstChild();
            for (DetailAstImpl descendant : descendantList) {
                pointer.getFirstChild().addPreviousSibling(descendant);
                pointer = descendant;
            }
        }
        bop.addChild(this.visit((ParseTree)ctx.children.get(2)));
        return bop;
    }

    private DetailAstImpl getInnerBopAst(JavaLanguageParser.BinOpContext descendant) {
        DetailAstImpl innerBop = this.create(descendant.bop);
        if (!(descendant.expr(0) instanceof JavaLanguageParser.BinOpContext)) {
            innerBop.addChild(this.visit((ParseTree)descendant.expr(0)));
        }
        innerBop.addChild(this.visit((ParseTree)descendant.expr(1)));
        return innerBop;
    }

    @Override
    public DetailAstImpl visitMethodCall(JavaLanguageParser.MethodCallContext ctx) {
        DetailAstImpl methodCall = this.create(27, (Token)ctx.LPAREN().getPayload());
        DetailAstImpl expressionList = Optional.ofNullable(this.visit((ParseTree)ctx.expressionList())).orElseGet(() -> JavaAstVisitor.createImaginary(34));
        DetailAstImpl dot = this.create(ctx.DOT());
        dot.addChild(this.visit((ParseTree)ctx.expr()));
        dot.addChild(this.visit((ParseTree)ctx.id()));
        methodCall.addChild(dot);
        methodCall.addChild(expressionList);
        methodCall.addChild(this.create((Token)ctx.RPAREN().getPayload()));
        return methodCall;
    }

    @Override
    public DetailAstImpl visitTypeCastParameters(JavaLanguageParser.TypeCastParametersContext ctx) {
        DetailAstImpl typeType = this.visit((ParseTree)ctx.typeType(0));
        for (int i = 0; i < ctx.BAND().size(); ++i) {
            JavaAstVisitor.addLastSibling(typeType, this.create(174, (Token)ctx.BAND(i).getPayload()));
            JavaAstVisitor.addLastSibling(typeType, this.visit((ParseTree)ctx.typeType(i + 1)));
        }
        return typeType;
    }

    @Override
    public DetailAstImpl visitLambdaExpression(JavaLanguageParser.LambdaExpressionContext ctx) {
        DetailAstImpl lambda = this.create(ctx.LAMBDA());
        lambda.addChild(this.visit((ParseTree)ctx.lambdaParameters()));
        lambda.addChild(this.visit((ParseTree)ctx.lambdaBody()));
        return lambda;
    }

    @Override
    public DetailAstImpl visitSingleLambdaParam(JavaLanguageParser.SingleLambdaParamContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitFormalLambdaParam(JavaLanguageParser.FormalLambdaParamContext ctx) {
        DetailAstImpl lparen = this.create(ctx.LPAREN());
        DetailAstImpl parameters = Optional.ofNullable(this.visit((ParseTree)ctx.formalParameterList())).orElseGet(() -> JavaAstVisitor.createImaginary(20));
        JavaAstVisitor.addLastSibling(lparen, parameters);
        JavaAstVisitor.addLastSibling(lparen, this.create(ctx.RPAREN()));
        return lparen;
    }

    @Override
    public DetailAstImpl visitMultiLambdaParam(JavaLanguageParser.MultiLambdaParamContext ctx) {
        DetailAstImpl lparen = this.create(ctx.LPAREN());
        JavaAstVisitor.addLastSibling(lparen, this.visit((ParseTree)ctx.multiLambdaParams()));
        JavaAstVisitor.addLastSibling(lparen, this.create(ctx.RPAREN()));
        return lparen;
    }

    @Override
    public DetailAstImpl visitMultiLambdaParams(JavaLanguageParser.MultiLambdaParamsContext ctx) {
        DetailAstImpl parameters = JavaAstVisitor.createImaginary(20);
        parameters.addChild(this.createLambdaParameter(ctx.id(0)));
        for (int i = 0; i < ctx.COMMA().size(); ++i) {
            parameters.addChild(this.create(ctx.COMMA(i)));
            parameters.addChild(this.createLambdaParameter(ctx.id(i + 1)));
        }
        return parameters;
    }

    private DetailAstImpl createLambdaParameter(JavaLanguageParser.IdContext ctx) {
        DetailAstImpl ident = this.visitId(ctx);
        DetailAstImpl parameter = JavaAstVisitor.createImaginary(21);
        DetailAstImpl modifiers = JavaAstVisitor.createImaginary(5);
        DetailAstImpl type = JavaAstVisitor.createImaginary(13);
        parameter.addChild(modifiers);
        parameter.addChild(type);
        parameter.addChild(ident);
        return parameter;
    }

    @Override
    public DetailAstImpl visitParenPrimary(JavaLanguageParser.ParenPrimaryContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitTokenPrimary(JavaLanguageParser.TokenPrimaryContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitClassRefPrimary(JavaLanguageParser.ClassRefPrimaryContext ctx) {
        DetailAstImpl dot = this.create(ctx.DOT());
        DetailAstImpl primaryTypeNoArray = this.visit((ParseTree)ctx.type);
        dot.addChild(primaryTypeNoArray);
        if (TokenUtil.isOfType(primaryTypeNoArray, 59)) {
            ctx.arrayDeclarator().forEach(child -> primaryTypeNoArray.addChild(this.visit((ParseTree)child)));
        } else {
            ctx.arrayDeclarator().forEach(child -> JavaAstVisitor.addLastSibling(primaryTypeNoArray, this.visit((ParseTree)child)));
        }
        dot.addChild(this.create(ctx.LITERAL_CLASS()));
        return dot;
    }

    @Override
    public DetailAstImpl visitPrimitivePrimary(JavaLanguageParser.PrimitivePrimaryContext ctx) {
        DetailAstImpl dot = this.create(ctx.DOT());
        DetailAstImpl primaryTypeNoArray = this.visit((ParseTree)ctx.type);
        dot.addChild(primaryTypeNoArray);
        ctx.arrayDeclarator().forEach(child -> dot.addChild(this.visit((ParseTree)child)));
        dot.addChild(this.create(ctx.LITERAL_CLASS()));
        return dot;
    }

    @Override
    public DetailAstImpl visitCreator(JavaLanguageParser.CreatorContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitCreatedNameObject(JavaLanguageParser.CreatedNameObjectContext ctx) {
        DetailAstPair currentAST = new DetailAstPair();
        DetailAstPair.addAstChild(currentAST, this.visit((ParseTree)ctx.annotations()));
        DetailAstPair.addAstChild(currentAST, this.visit((ParseTree)ctx.id()));
        DetailAstPair.addAstChild(currentAST, this.visit((ParseTree)ctx.typeArgumentsOrDiamond()));
        for (ParserRuleContext parserRuleContext : ctx.extended) {
            DetailAstImpl dot = this.create(parserRuleContext.start);
            DetailAstPair.makeAstRoot(currentAST, dot);
            List childList = parserRuleContext.children.subList(1, parserRuleContext.children.size());
            this.processChildren(dot, childList);
        }
        return currentAST.root;
    }

    @Override
    public DetailAstImpl visitCreatedNamePrimitive(JavaLanguageParser.CreatedNamePrimitiveContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitInnerCreator(JavaLanguageParser.InnerCreatorContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitArrayCreatorRest(JavaLanguageParser.ArrayCreatorRestContext ctx) {
        DetailAstImpl arrayDeclarator = this.create(17, (Token)ctx.LBRACK().getPayload());
        for (int i = 1; i < ctx.children.size(); ++i) {
            if (ctx.children.get(i) == ctx.RBRACK()) {
                arrayDeclarator.addChild(this.create(ctx.RBRACK()));
                continue;
            }
            if (ctx.children.get(i) == ctx.expression()) {
                arrayDeclarator.addChild(this.visit((ParseTree)ctx.expression()));
                continue;
            }
            JavaAstVisitor.addLastSibling(arrayDeclarator, this.visit((ParseTree)ctx.children.get(i)));
        }
        return arrayDeclarator;
    }

    @Override
    public DetailAstImpl visitBracketsWithExp(JavaLanguageParser.BracketsWithExpContext ctx) {
        DetailAstImpl dummyRoot = new DetailAstImpl();
        dummyRoot.addChild(this.visit((ParseTree)ctx.annotations()));
        DetailAstImpl arrayDeclarator = this.create(17, (Token)ctx.LBRACK().getPayload());
        arrayDeclarator.addChild(this.visit((ParseTree)ctx.expression()));
        arrayDeclarator.addChild(this.create(ctx.stop));
        dummyRoot.addChild(arrayDeclarator);
        return dummyRoot.getFirstChild();
    }

    @Override
    public DetailAstImpl visitClassCreatorRest(JavaLanguageParser.ClassCreatorRestContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitDiamond(JavaLanguageParser.DiamondContext ctx) {
        DetailAstImpl typeArguments = JavaAstVisitor.createImaginary(163);
        typeArguments.addChild(this.create(172, (Token)ctx.LT().getPayload()));
        typeArguments.addChild(this.create(173, (Token)ctx.GT().getPayload()));
        return typeArguments;
    }

    @Override
    public DetailAstImpl visitTypeArgs(JavaLanguageParser.TypeArgsContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitNonWildcardDiamond(JavaLanguageParser.NonWildcardDiamondContext ctx) {
        DetailAstImpl typeArguments = JavaAstVisitor.createImaginary(163);
        typeArguments.addChild(this.create(172, (Token)ctx.LT().getPayload()));
        typeArguments.addChild(this.create(173, (Token)ctx.GT().getPayload()));
        return typeArguments;
    }

    @Override
    public DetailAstImpl visitNonWildcardTypeArguments(JavaLanguageParser.NonWildcardTypeArgumentsContext ctx) {
        DetailAstImpl typeArguments = JavaAstVisitor.createImaginary(163);
        typeArguments.addChild(this.create(172, (Token)ctx.LT().getPayload()));
        typeArguments.addChild(this.visit((ParseTree)ctx.typeArgumentsTypeList()));
        typeArguments.addChild(this.create(173, (Token)ctx.GT().getPayload()));
        return typeArguments;
    }

    @Override
    public DetailAstImpl visitTypeArgumentsTypeList(JavaLanguageParser.TypeArgumentsTypeListContext ctx) {
        DetailAstImpl firstIdent = this.visit((ParseTree)ctx.typeType(0));
        DetailAstImpl firstTypeArgument = JavaAstVisitor.createImaginary(164);
        firstTypeArgument.addChild(firstIdent);
        for (int i = 0; i < ctx.COMMA().size(); ++i) {
            JavaAstVisitor.addLastSibling(firstTypeArgument, this.create(ctx.COMMA(i)));
            DetailAstImpl ident = this.visit((ParseTree)ctx.typeType(i + 1));
            DetailAstImpl typeArgument = JavaAstVisitor.createImaginary(164);
            typeArgument.addChild(ident);
            JavaAstVisitor.addLastSibling(firstTypeArgument, typeArgument);
        }
        return firstTypeArgument;
    }

    @Override
    public DetailAstImpl visitTypeList(JavaLanguageParser.TypeListContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public DetailAstImpl visitTypeType(JavaLanguageParser.TypeTypeContext ctx) {
        DetailAstImpl type = JavaAstVisitor.createImaginary(13);
        this.processChildren(type, ctx.children);
        DetailAstImpl returnTree = ctx.createImaginaryNode ? type : type.getFirstChild();
        return returnTree;
    }

    @Override
    public DetailAstImpl visitArrayDeclarator(JavaLanguageParser.ArrayDeclaratorContext ctx) {
        DetailAstImpl returnTree;
        DetailAstImpl arrayDeclarator = this.create(17, (Token)ctx.LBRACK().getPayload());
        arrayDeclarator.addChild(this.create(ctx.RBRACK()));
        DetailAstImpl annotations = this.visit((ParseTree)ctx.anno);
        if (annotations == null) {
            returnTree = arrayDeclarator;
        } else {
            returnTree = annotations;
            JavaAstVisitor.addLastSibling(returnTree, arrayDeclarator);
        }
        return returnTree;
    }

    @Override
    public DetailAstImpl visitPrimitiveType(JavaLanguageParser.PrimitiveTypeContext ctx) {
        return this.create(ctx.start);
    }

    @Override
    public DetailAstImpl visitTypeArguments(JavaLanguageParser.TypeArgumentsContext ctx) {
        DetailAstImpl typeArguments = JavaAstVisitor.createImaginary(163);
        typeArguments.addChild(this.create(172, (Token)ctx.LT().getPayload()));
        this.processChildren(typeArguments, ctx.children.subList(1, ctx.children.size() - 1));
        typeArguments.addChild(this.create(173, (Token)ctx.GT().getPayload()));
        return typeArguments;
    }

    @Override
    public DetailAstImpl visitSuperSuffixDot(JavaLanguageParser.SuperSuffixDotContext ctx) {
        DetailAstImpl root;
        if (ctx.LPAREN() == null) {
            root = this.create(ctx.DOT());
            root.addChild(this.visit((ParseTree)ctx.id()));
        } else {
            root = this.create(27, (Token)ctx.LPAREN().getPayload());
            DetailAstImpl dot = this.create(ctx.DOT());
            dot.addChild(this.visit((ParseTree)ctx.id()));
            root.addChild(dot);
            DetailAstImpl expressionList = Optional.ofNullable(this.visit((ParseTree)ctx.expressionList())).orElseGet(() -> JavaAstVisitor.createImaginary(34));
            root.addChild(expressionList);
            root.addChild(this.create(ctx.RPAREN()));
        }
        return root;
    }

    @Override
    public DetailAstImpl visitArguments(JavaLanguageParser.ArgumentsContext ctx) {
        DetailAstImpl lparen = this.create(ctx.LPAREN());
        DetailAstImpl expressionList = Optional.ofNullable(this.visit((ParseTree)ctx.expressionList())).orElseGet(() -> JavaAstVisitor.createImaginary(34));
        JavaAstVisitor.addLastSibling(lparen, expressionList);
        JavaAstVisitor.addLastSibling(lparen, this.create(ctx.RPAREN()));
        return lparen;
    }

    @Override
    public DetailAstImpl visitPattern(JavaLanguageParser.PatternContext ctx) {
        DetailAstImpl pattern;
        boolean isSimpleTypePattern;
        JavaLanguageParser.PrimaryPatternContext primaryPattern = ctx.primaryPattern();
        boolean bl = isSimpleTypePattern = primaryPattern != null && primaryPattern.getChild(0) instanceof JavaLanguageParser.TypePatternContext;
        if (isSimpleTypePattern) {
            pattern = this.visit((ParseTree)ctx.primaryPattern());
        } else {
            pattern = JavaAstVisitor.createImaginary(213);
            pattern.addChild(this.visit(ctx.getChild(0)));
        }
        return pattern;
    }

    @Override
    public DetailAstImpl visitGuardedPattern(JavaLanguageParser.GuardedPatternContext ctx) {
        DetailAstImpl logicalAnd = this.create(ctx.LAND());
        logicalAnd.addChild(this.visit((ParseTree)ctx.primaryPattern()));
        logicalAnd.addChild(this.visit((ParseTree)ctx.expr()));
        return logicalAnd;
    }

    @Override
    public DetailAstImpl visitParenPattern(JavaLanguageParser.ParenPatternContext ctx) {
        DetailAstImpl lparen = this.create(ctx.LPAREN());
        ParseTree innerPattern = ctx.getChild(1);
        lparen.addChild(this.visit(innerPattern));
        lparen.addChild(this.create(ctx.RPAREN()));
        return lparen;
    }

    @Override
    public DetailAstImpl visitTypePattern(JavaLanguageParser.TypePatternContext ctx) {
        DetailAstImpl type = this.visit((ParseTree)ctx.type);
        DetailAstImpl patternVariableDef = JavaAstVisitor.createImaginary(198);
        patternVariableDef.addChild(this.createModifiers(ctx.mods));
        patternVariableDef.addChild(type);
        patternVariableDef.addChild(this.visit((ParseTree)ctx.id()));
        return patternVariableDef;
    }

    @Override
    public DetailAstImpl visitPermittedSubclassesAndInterfaces(JavaLanguageParser.PermittedSubclassesAndInterfacesContext ctx) {
        DetailAstImpl literalPermits = this.create(212, (Token)ctx.LITERAL_PERMITS().getPayload());
        this.processChildren(literalPermits, ctx.children.subList(1, ctx.children.size()));
        return literalPermits;
    }

    @Override
    public DetailAstImpl visitId(JavaLanguageParser.IdContext ctx) {
        return this.create(58, ctx.start);
    }

    private DetailAstImpl flattenedTree(ParserRuleContext ctx) {
        DetailAstImpl dummyNode = new DetailAstImpl();
        this.processChildren(dummyNode, ctx.children);
        return dummyNode.getFirstChild();
    }

    private void processChildren(DetailAstImpl parent, List<? extends ParseTree> children) {
        children.forEach(child -> {
            if (child instanceof TerminalNode) {
                parent.addChild(this.create((TerminalNode)child));
            } else {
                parent.addChild(this.visit((ParseTree)child));
            }
        });
    }

    private static DetailAstImpl createImaginary(int tokenType) {
        DetailAstImpl detailAst = new DetailAstImpl();
        detailAst.setType(tokenType);
        detailAst.setText(TokenUtil.getTokenName(tokenType));
        return detailAst;
    }

    private DetailAstImpl create(int tokenType, Token startToken) {
        DetailAstImpl ast = this.create(startToken);
        ast.setType(tokenType);
        return ast;
    }

    private DetailAstImpl create(Token token) {
        int tokenIndex = token.getTokenIndex();
        List tokensToLeft = this.tokens.getHiddenTokensToLeft(tokenIndex, 2);
        List tokensToRight = this.tokens.getHiddenTokensToRight(tokenIndex, 2);
        DetailAstImpl detailAst = new DetailAstImpl();
        detailAst.initialize(token);
        if (tokensToLeft != null) {
            detailAst.setHiddenBefore(tokensToLeft);
        }
        if (tokensToRight != null) {
            detailAst.setHiddenAfter(tokensToRight);
        }
        return detailAst;
    }

    private DetailAstImpl create(TerminalNode node) {
        return this.create((Token)node.getPayload());
    }

    private DetailAstImpl createTypeDeclaration(ParserRuleContext ctx, int type, List<? extends ParseTree> modifierList) {
        DetailAstImpl typeDeclaration = JavaAstVisitor.createImaginary(type);
        typeDeclaration.addChild(this.createModifiers(modifierList));
        this.processChildren(typeDeclaration, ctx.children);
        return typeDeclaration;
    }

    private DetailAstImpl createModifiers(List<? extends ParseTree> modifierList) {
        DetailAstImpl mods = JavaAstVisitor.createImaginary(5);
        this.processChildren(mods, modifierList);
        return mods;
    }

    private static void addLastSibling(DetailAstImpl self, DetailAstImpl sibling) {
        DetailAstImpl nextSibling = self;
        if (nextSibling != null) {
            while (nextSibling.getNextSibling() != null) {
                nextSibling = nextSibling.getNextSibling();
            }
            nextSibling.setNextSibling(sibling);
        }
    }

    public DetailAstImpl visit(ParseTree tree) {
        DetailAstImpl ast = null;
        if (tree != null) {
            ast = (DetailAstImpl)tree.accept((ParseTreeVisitor)this);
        }
        return ast;
    }

    private static final class DetailAstPair {
        private DetailAstImpl root;
        private DetailAstImpl child;

        private DetailAstPair() {
        }

        private void advanceChildToEnd() {
            while (this.child.getNextSibling() != null) {
                this.child = this.child.getNextSibling();
            }
        }

        private DetailAstImpl getRoot() {
            return this.root;
        }

        private static void makeAstRoot(DetailAstPair pair, DetailAstImpl ast) {
            ast.addChild(pair.root);
            pair.child = pair.root;
            pair.advanceChildToEnd();
            pair.root = ast;
        }

        private static void addAstChild(DetailAstPair pair, DetailAstImpl ast) {
            if (ast != null) {
                if (pair.root == null) {
                    pair.root = ast;
                } else {
                    pair.child.setNextSibling(ast);
                }
                pair.child = ast;
                pair.advanceChildToEnd();
            }
        }
    }
}

