/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AstTreeStringPrinter;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.DetailNodeTreeStringPrinter;
import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.SuppressionsStringPrinter;
import com.puppycrawl.tools.checkstyle.ThreadModeSettings;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.XpathFileGeneratorAstFilter;
import com.puppycrawl.tools.checkstyle.XpathFileGeneratorAuditListener;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.RootModule;
import com.puppycrawl.tools.checkstyle.api.Violation;
import com.puppycrawl.tools.checkstyle.utils.ChainedPropertyUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.XpathUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import picocli.CommandLine;

public final class Main {
    public static final String ERROR_COUNTER = "Main.errorCounter";
    public static final String LOAD_PROPERTIES_EXCEPTION = "Main.loadProperties";
    public static final String CREATE_LISTENER_EXCEPTION = "Main.createListener";
    private static final Log LOG = LogFactory.getLog(Main.class);
    private static final int EXIT_WITH_INVALID_USER_INPUT_CODE = -1;
    private static final int EXIT_WITH_CHECKSTYLE_EXCEPTION_CODE = -2;

    private Main() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String ... args) throws IOException {
        int exitStatus;
        block15: {
            CliOptions cliOptions = new CliOptions();
            CommandLine commandLine = new CommandLine((Object)cliOptions);
            commandLine.setUsageHelpWidth(100);
            commandLine.setCaseInsensitiveEnumValuesAllowed(true);
            exitStatus = 0;
            int errorCounter = 0;
            try {
                CommandLine.ParseResult parseResult = commandLine.parseArgs(args);
                if (parseResult.isVersionHelpRequested()) {
                    System.out.println(Main.getVersionString());
                } else if (parseResult.isUsageHelpRequested()) {
                    commandLine.usage(System.out);
                } else {
                    errorCounter = exitStatus = Main.execute(parseResult, cliOptions);
                }
                if (errorCounter <= 0) break block15;
            }
            catch (CommandLine.ParameterException ex) {
                block16: {
                    exitStatus = -1;
                    System.err.println(ex.getMessage());
                    System.err.println("Usage: checkstyle [OPTIONS]... FILES...");
                    System.err.println("Try 'checkstyle --help' for more information.");
                    if (errorCounter <= 0) break block16;
                    Violation errorCounterViolation = new Violation(1, "com.puppycrawl.tools.checkstyle.messages", ERROR_COUNTER, new String[]{String.valueOf(errorCounter)}, null, Main.class, null);
                    System.err.println(errorCounterViolation.getViolation());
                }
                if (exitStatus != 0) {
                    System.exit(exitStatus);
                }
            }
            catch (CheckstyleException ex2) {
                block17: {
                    exitStatus = -2;
                    errorCounter = 1;
                    ex2.printStackTrace();
                    if (errorCounter <= 0) break block17;
                    {
                        catch (Throwable throwable) {
                            if (errorCounter > 0) {
                                Violation errorCounterViolation = new Violation(1, "com.puppycrawl.tools.checkstyle.messages", ERROR_COUNTER, new String[]{String.valueOf(errorCounter)}, null, Main.class, null);
                                System.err.println(errorCounterViolation.getViolation());
                            }
                            if (exitStatus != 0) {
                                System.exit(exitStatus);
                            }
                            throw throwable;
                        }
                    }
                    Violation errorCounterViolation = new Violation(1, "com.puppycrawl.tools.checkstyle.messages", ERROR_COUNTER, new String[]{String.valueOf(errorCounter)}, null, Main.class, null);
                    System.err.println(errorCounterViolation.getViolation());
                }
                if (exitStatus != 0) {
                    System.exit(exitStatus);
                }
            }
            Violation errorCounterViolation = new Violation(1, "com.puppycrawl.tools.checkstyle.messages", ERROR_COUNTER, new String[]{String.valueOf(errorCounter)}, null, Main.class, null);
            System.err.println(errorCounterViolation.getViolation());
        }
        if (exitStatus != 0) {
            System.exit(exitStatus);
        }
    }

    private static String getVersionString() {
        return "Checkstyle version: " + Main.class.getPackage().getImplementationVersion();
    }

    private static int execute(CommandLine.ParseResult parseResult, CliOptions options) throws IOException, CheckstyleException {
        int exitStatus;
        boolean hasMessages;
        List<File> filesToProcess = Main.getFilesToProcess(options);
        List messages = options.validateCli(parseResult, filesToProcess);
        boolean bl = hasMessages = !messages.isEmpty();
        if (hasMessages) {
            messages.forEach(System.out::println);
            exitStatus = -1;
        } else {
            exitStatus = Main.runCli(options, filesToProcess);
        }
        return exitStatus;
    }

    private static List<File> getFilesToProcess(CliOptions options) {
        List patternsToExclude = options.getExclusions();
        LinkedList<File> result = new LinkedList<File>();
        for (File file : options.files) {
            result.addAll(Main.listFiles(file, patternsToExclude));
        }
        return result;
    }

    private static List<File> listFiles(File node, List<Pattern> patternsToExclude) {
        LinkedList<File> result = new LinkedList<File>();
        if (node.canRead() && !Main.isPathExcluded(node.getAbsolutePath(), patternsToExclude)) {
            if (node.isDirectory()) {
                File[] files = node.listFiles();
                if (files != null) {
                    for (File element : files) {
                        result.addAll(Main.listFiles(element, patternsToExclude));
                    }
                }
            } else if (node.isFile()) {
                result.add(node);
            }
        }
        return result;
    }

    private static boolean isPathExcluded(String path, List<Pattern> patternsToExclude) {
        boolean result = false;
        for (Pattern pattern : patternsToExclude) {
            if (!pattern.matcher(path).find()) continue;
            result = true;
            break;
        }
        return result;
    }

    private static int runCli(CliOptions options, List<File> filesToProcess) throws IOException, CheckstyleException {
        boolean hasSuppressionLineColumnNumber;
        int result = 0;
        boolean bl = hasSuppressionLineColumnNumber = options.suppressionLineColumnNumber != null;
        if (options.printAst) {
            File file = filesToProcess.get(0);
            String stringAst = AstTreeStringPrinter.printFileAst(file, JavaParser.Options.WITHOUT_COMMENTS);
            System.out.print(stringAst);
        } else if (Objects.nonNull(options.xpath)) {
            String branch = XpathUtil.printXpathBranch(options.xpath, filesToProcess.get(0));
            System.out.print(branch);
        } else if (options.printAstWithComments) {
            File file = filesToProcess.get(0);
            String stringAst = AstTreeStringPrinter.printFileAst(file, JavaParser.Options.WITH_COMMENTS);
            System.out.print(stringAst);
        } else if (options.printJavadocTree) {
            File file = filesToProcess.get(0);
            String stringAst = DetailNodeTreeStringPrinter.printFileAst(file);
            System.out.print(stringAst);
        } else if (options.printTreeWithJavadoc) {
            File file = filesToProcess.get(0);
            String stringAst = AstTreeStringPrinter.printJavaAndJavadocTree(file);
            System.out.print(stringAst);
        } else if (hasSuppressionLineColumnNumber) {
            File file = filesToProcess.get(0);
            String stringSuppressions = SuppressionsStringPrinter.printSuppressions(file, options.suppressionLineColumnNumber, options.tabWidth);
            System.out.print(stringSuppressions);
        } else {
            if (options.debug) {
                Logger parentLogger = Logger.getLogger(Main.class.getName()).getParent();
                ConsoleHandler handler = new ConsoleHandler();
                handler.setLevel(Level.FINEST);
                handler.setFilter(new OnlyCheckstyleLoggersFilter());
                parentLogger.addHandler(handler);
                parentLogger.setLevel(Level.FINEST);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checkstyle debug logging enabled");
                LOG.debug((Object)("Running Checkstyle with version: " + Main.class.getPackage().getImplementationVersion()));
            }
            result = Main.runCheckstyle(options, filesToProcess);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runCheckstyle(CliOptions options, List<File> filesToProcess) throws CheckstyleException, IOException {
        int errorCounter;
        Properties props = options.propertiesFile == null ? System.getProperties() : Main.loadProperties(options.propertiesFile);
        ThreadModeSettings multiThreadModeSettings = new ThreadModeSettings(1, 1);
        ConfigurationLoader.IgnoredModulesOptions ignoredModulesOptions = options.executeIgnoredModules ? ConfigurationLoader.IgnoredModulesOptions.EXECUTE : ConfigurationLoader.IgnoredModulesOptions.OMIT;
        Configuration config = ConfigurationLoader.loadConfiguration(options.configurationFile, (PropertyResolver)new PropertiesExpander(props), ignoredModulesOptions, multiThreadModeSettings);
        ClassLoader moduleClassLoader = Checker.class.getClassLoader();
        RootModule rootModule = Main.getRootModule(config.getName(), moduleClassLoader);
        try {
            AuditListener listener;
            if (options.generateXpathSuppressionsFile) {
                Configuration treeWalkerConfig = Main.getTreeWalkerConfig(config);
                if (treeWalkerConfig != null) {
                    DefaultConfiguration moduleConfig = new DefaultConfiguration(XpathFileGeneratorAstFilter.class.getName());
                    moduleConfig.addAttribute("tabWidth", String.valueOf(options.tabWidth));
                    ((DefaultConfiguration)treeWalkerConfig).addChild(moduleConfig);
                }
                listener = new XpathFileGeneratorAuditListener(Main.getOutputStream(options.outputPath), Main.getOutputStreamOptions(options.outputPath));
            } else {
                listener = Main.createListener(options.format, options.outputPath);
            }
            rootModule.setModuleClassLoader(moduleClassLoader);
            rootModule.configure(config);
            rootModule.addListener(listener);
            errorCounter = rootModule.process(filesToProcess);
        }
        finally {
            rootModule.destroy();
        }
        return errorCounter;
    }

    private static Properties loadProperties(File file) throws CheckstyleException {
        Properties properties = new Properties();
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            properties.load(stream);
        }
        catch (IOException ex) {
            Violation loadPropertiesExceptionMessage = new Violation(1, "com.puppycrawl.tools.checkstyle.messages", LOAD_PROPERTIES_EXCEPTION, new String[]{file.getAbsolutePath()}, null, Main.class, null);
            throw new CheckstyleException(loadPropertiesExceptionMessage.getViolation(), ex);
        }
        return ChainedPropertyUtil.getResolvedProperties(properties);
    }

    private static RootModule getRootModule(String name, ClassLoader moduleClassLoader) throws CheckstyleException {
        PackageObjectFactory factory = new PackageObjectFactory(Checker.class.getPackage().getName(), moduleClassLoader);
        return (RootModule)factory.createModule(name);
    }

    private static Configuration getTreeWalkerConfig(Configuration config) {
        Configuration[] children;
        Configuration result = null;
        for (Configuration child : children = config.getChildren()) {
            if (!"TreeWalker".equals(child.getName())) continue;
            result = child;
            break;
        }
        return result;
    }

    private static AuditListener createListener(OutputFormat format, Path outputLocation) throws IOException {
        OutputStream out = Main.getOutputStream(outputLocation);
        AutomaticBean.OutputStreamOptions closeOutputStreamOption = Main.getOutputStreamOptions(outputLocation);
        return format.createListener(out, closeOutputStreamOption);
    }

    private static OutputStream getOutputStream(Path outputPath) throws IOException {
        OutputStream result = outputPath == null ? System.out : Files.newOutputStream(outputPath, new OpenOption[0]);
        return result;
    }

    private static AutomaticBean.OutputStreamOptions getOutputStreamOptions(Path outputPath) {
        AutomaticBean.OutputStreamOptions result = outputPath == null ? AutomaticBean.OutputStreamOptions.NONE : AutomaticBean.OutputStreamOptions.CLOSE;
        return result;
    }

    @CommandLine.Command(name="checkstyle", description={"Checkstyle verifies that the specified source code files adhere to the specified rules. By default violations are reported to standard out in plain format. Checkstyle requires a configuration XML file that configures the checks to apply."}, mixinStandardHelpOptions=true)
    private static class CliOptions {
        private static final int HELP_WIDTH = 100;
        private static final int DEFAULT_THREAD_COUNT = 1;
        private static final String ATTRIB_TAB_WIDTH_NAME = "tabWidth";
        private static final OutputFormat DEFAULT_OUTPUT_FORMAT = OutputFormat.PLAIN;
        private static final String OUTPUT_FORMAT_OPTION = "-f";
        private static final int CHECKER_THREADS_NUMBER = 1;
        private static final int TREE_WALKER_THREADS_NUMBER = 1;
        @CommandLine.Parameters(arity="1..*", description={"One or more source files to verify"})
        private List<File> files;
        @CommandLine.Option(names={"-c"}, description={"Specifies the location of the file that defines the configuration modules. The location can either be a filesystem location, or a name passed to the ClassLoader.getResource() method."})
        private String configurationFile;
        @CommandLine.Option(names={"-o"}, description={"Sets the output file. Defaults to stdout."})
        private Path outputPath;
        @CommandLine.Option(names={"-p"}, description={"Sets the property files to load."})
        private File propertiesFile;
        @CommandLine.Option(names={"-s"}, description={"Prints xpath suppressions at the file's line and column position. Argument is the line and column number (separated by a : ) in the file that the suppression should be generated for. The option cannot be used with other options and requires exactly one file to run on to be specified. ATTENTION: generated result will have few queries, joined by pipe(|). Together they will match all AST nodes on specified line and column. You need to choose only one and recheck that it works. Usage of all of them is also ok, but might result in undesirable matching and suppress other issues."})
        private String suppressionLineColumnNumber;
        @CommandLine.Option(names={"-w", "--tabWidth"}, description={"Sets the length of the tab character. Used only with -s option. Default value is ${DEFAULT-VALUE}."})
        private int tabWidth = 8;
        @CommandLine.Option(names={"-g", "--generate-xpath-suppression"}, description={"Generates to output a suppression xml to use to suppress all violations from user's config. Instead of printing every violation, all violations will be catched and single suppressions xml file will be printed out. Used only with -c option. Output location can be specified with -o option."})
        private boolean generateXpathSuppressionsFile;
        @CommandLine.Option(names={"-f"}, description={"Specifies the output format. Valid values: ${COMPLETION-CANDIDATES} for XMLLogger and DefaultLogger respectively. Defaults to ${DEFAULT-VALUE}."})
        private OutputFormat format = DEFAULT_OUTPUT_FORMAT;
        @CommandLine.Option(names={"-t", "--tree"}, description={"Prints Abstract Syntax Tree(AST) of the checked file. The option cannot be used other options and requires exactly one file to run on to be specified."})
        private boolean printAst;
        @CommandLine.Option(names={"-T", "--treeWithComments"}, description={"Prints Abstract Syntax Tree(AST) with comment nodes of the checked file. The option cannot be used with other options and requires exactly one file to run on to be specified."})
        private boolean printAstWithComments;
        @CommandLine.Option(names={"-j", "--javadocTree"}, description={"Prints Parse Tree of the Javadoc comment. The file have to contain only Javadoc comment content without including '/**' and '*/' at the beginning and at the end respectively. The option cannot be used other options and requires exactly one file to run on to be specified."})
        private boolean printJavadocTree;
        @CommandLine.Option(names={"-J", "--treeWithJavadoc"}, description={"Prints Abstract Syntax Tree(AST) with Javadoc nodes and comment nodes of the checked file. Attention that line number and columns will not be the same as it is a file due to the fact that each javadoc comment is parsed separately from java file. The option cannot be used with other options and requires exactly one file to run on to be specified."})
        private boolean printTreeWithJavadoc;
        @CommandLine.Option(names={"-d", "--debug"}, description={"Prints all debug logging of CheckStyle utility."})
        private boolean debug;
        @CommandLine.Option(names={"-e", "--exclude"}, description={"Directory/file to exclude from CheckStyle. The path can be the full, absolute path, or relative to the current path. Multiple excludes are allowed."})
        private List<File> exclude = new ArrayList<File>();
        @CommandLine.Option(names={"-x", "--exclude-regexp"}, description={"Directory/file pattern to exclude from CheckStyle. Multiple excludes are allowed."})
        private List<Pattern> excludeRegex = new ArrayList<Pattern>();
        @CommandLine.Option(names={"-E", "--executeIgnoredModules"}, description={"Allows ignored modules to be run."})
        private boolean executeIgnoredModules;
        @CommandLine.Option(names={"-b", "--branch-matching-xpath"}, description={"Shows Abstract Syntax Tree(AST) branches that match given XPath query."})
        private String xpath;

        private CliOptions() {
        }

        private List<Pattern> getExclusions() {
            List result = this.exclude.stream().map(File::getAbsolutePath).map(Pattern::quote).map(pattern -> Pattern.compile("^" + pattern + "$")).collect(Collectors.toCollection(ArrayList::new));
            result.addAll(this.excludeRegex);
            return result;
        }

        private List<String> validateCli(CommandLine.ParseResult parseResult, List<File> filesToProcess) {
            boolean hasSuppressionLineColumnNumber;
            ArrayList<String> result = new ArrayList<String>();
            boolean hasConfigurationFile = this.configurationFile != null;
            boolean bl = hasSuppressionLineColumnNumber = this.suppressionLineColumnNumber != null;
            if (filesToProcess.isEmpty()) {
                result.add("Files to process must be specified, found 0.");
            } else if (this.printAst || this.printAstWithComments || this.printJavadocTree || this.printTreeWithJavadoc || this.xpath != null) {
                if (this.suppressionLineColumnNumber != null || this.configurationFile != null || this.propertiesFile != null || this.outputPath != null || parseResult.hasMatchedOption(OUTPUT_FORMAT_OPTION)) {
                    result.add("Option '-t' cannot be used with other options.");
                } else if (filesToProcess.size() > 1) {
                    result.add("Printing AST is allowed for only one file.");
                }
            } else if (hasSuppressionLineColumnNumber) {
                if (this.configurationFile != null || this.propertiesFile != null || this.outputPath != null || parseResult.hasMatchedOption(OUTPUT_FORMAT_OPTION)) {
                    result.add("Option '-s' cannot be used with other options.");
                } else if (filesToProcess.size() > 1) {
                    result.add("Printing xpath suppressions is allowed for only one file.");
                }
            } else if (hasConfigurationFile) {
                try {
                    CommonUtil.getUriByFilename(this.configurationFile);
                }
                catch (CheckstyleException ignored) {
                    String msg = "Could not find config XML file '%s'.";
                    result.add(String.format(Locale.ROOT, "Could not find config XML file '%s'.", this.configurationFile));
                }
                result.addAll(this.validateOptionalCliParametersIfConfigDefined());
            } else {
                result.add("Must specify a config XML file.");
            }
            return result;
        }

        private List<String> validateOptionalCliParametersIfConfigDefined() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.propertiesFile != null && !this.propertiesFile.exists()) {
                result.add(String.format(Locale.ROOT, "Could not find file '%s'.", this.propertiesFile));
            }
            return result;
        }
    }

    private static final class OnlyCheckstyleLoggersFilter
    implements Filter {
        private final String packageName = Main.class.getPackage().getName();

        private OnlyCheckstyleLoggersFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord logRecord) {
            return logRecord.getLoggerName().startsWith(this.packageName);
        }
    }

    static enum OutputFormat {
        XML,
        PLAIN;


        public AuditListener createListener(OutputStream out, AutomaticBean.OutputStreamOptions options) {
            AutomaticBean result = this == XML ? new XMLLogger(out, options) : new DefaultLogger(out, options);
            return result;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

