/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.TreeWalkerAuditEvent;
import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ExternalResourceHolder;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@FileStatefulCheck
public final class TreeWalker
extends AbstractFileSetCheck
implements ExternalResourceHolder {
    private final Map<Integer, Set<AbstractCheck>> tokenToOrdinaryChecks = new HashMap<Integer, Set<AbstractCheck>>();
    private final Map<Integer, Set<AbstractCheck>> tokenToCommentChecks = new HashMap<Integer, Set<AbstractCheck>>();
    private final Set<AbstractCheck> ordinaryChecks = TreeWalker.createNewCheckSortedSet();
    private final Set<AbstractCheck> commentChecks = TreeWalker.createNewCheckSortedSet();
    private final Set<TreeWalkerFilter> filters = new HashSet<TreeWalkerFilter>();
    private final SortedSet<LocalizedMessage> messages = new TreeSet<LocalizedMessage>();
    private Context childContext;
    private ModuleFactory moduleFactory;

    public TreeWalker() {
        this.setFileExtensions("java");
    }

    public void setModuleFactory(ModuleFactory moduleFactory) {
        this.moduleFactory = moduleFactory;
    }

    @Override
    public void finishLocalSetup() {
        DefaultContext checkContext = new DefaultContext();
        checkContext.add("severity", this.getSeverity());
        checkContext.add("tabWidth", String.valueOf(this.getTabWidth()));
        this.childContext = checkContext;
    }

    @Override
    public void setupChild(Configuration childConf) throws CheckstyleException {
        Object module;
        String name = childConf.getName();
        try {
            module = this.moduleFactory.createModule(name);
            if (module instanceof AutomaticBean) {
                AutomaticBean bean = (AutomaticBean)module;
                bean.contextualize(this.childContext);
                bean.configure(childConf);
            }
        }
        catch (CheckstyleException ex) {
            throw new CheckstyleException("cannot initialize module " + name + " - " + ex.getMessage(), ex);
        }
        if (module instanceof AbstractCheck) {
            AbstractCheck check = (AbstractCheck)module;
            check.init();
            this.registerCheck(check);
        } else if (module instanceof TreeWalkerFilter) {
            TreeWalkerFilter filter = (TreeWalkerFilter)module;
            this.filters.add(filter);
        } else {
            throw new CheckstyleException("TreeWalker is not allowed as a parent of " + name + " Please review 'Parent Module' section for this Check in web documentation if Check is standard.");
        }
    }

    @Override
    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        if (!this.ordinaryChecks.isEmpty() || !this.commentChecks.isEmpty()) {
            FileContents contents = this.getFileContents();
            DetailAST rootAST = JavaParser.parse(contents);
            if (!this.ordinaryChecks.isEmpty()) {
                this.walk(rootAST, contents, AstState.ORDINARY);
            }
            if (!this.commentChecks.isEmpty()) {
                DetailAST astWithComments = JavaParser.appendHiddenCommentNodes(rootAST);
                this.walk(astWithComments, contents, AstState.WITH_COMMENTS);
            }
            if (this.filters.isEmpty()) {
                this.addMessages(this.messages);
            } else {
                SortedSet<LocalizedMessage> filteredMessages = this.getFilteredMessages(file.getAbsolutePath(), contents, rootAST);
                this.addMessages(filteredMessages);
            }
            this.messages.clear();
        }
    }

    private SortedSet<LocalizedMessage> getFilteredMessages(String fileName, FileContents fileContents, DetailAST rootAST) {
        TreeSet<LocalizedMessage> result = new TreeSet<LocalizedMessage>(this.messages);
        block0: for (LocalizedMessage element : this.messages) {
            TreeWalkerAuditEvent event = new TreeWalkerAuditEvent(fileContents, fileName, element, rootAST);
            for (TreeWalkerFilter filter : this.filters) {
                if (filter.accept(event)) continue;
                result.remove(element);
                continue block0;
            }
        }
        return result;
    }

    private void registerCheck(AbstractCheck check) throws CheckstyleException {
        int[] tokens;
        Set<String> checkTokens = check.getTokenNames();
        if (checkTokens.isEmpty()) {
            tokens = check.getDefaultTokens();
        } else {
            tokens = check.getRequiredTokens();
            int[] acceptableTokens = check.getAcceptableTokens();
            Arrays.sort(acceptableTokens);
            for (String token : checkTokens) {
                int tokenId = TokenUtil.getTokenId(token);
                if (Arrays.binarySearch(acceptableTokens, tokenId) >= 0) {
                    this.registerCheck(tokenId, check);
                    continue;
                }
                String message = String.format(Locale.ROOT, "Token \"%s\" was not found in Acceptable tokens list in check %s", token, check.getClass().getName());
                throw new CheckstyleException(message);
            }
        }
        for (int element : tokens) {
            this.registerCheck(element, check);
        }
        if (check.isCommentNodesRequired()) {
            this.commentChecks.add(check);
        } else {
            this.ordinaryChecks.add(check);
        }
    }

    private void registerCheck(int tokenId, AbstractCheck check) throws CheckstyleException {
        if (check.isCommentNodesRequired()) {
            this.tokenToCommentChecks.computeIfAbsent(tokenId, empty -> TreeWalker.createNewCheckSortedSet()).add(check);
        } else {
            if (TokenUtil.isCommentType(tokenId)) {
                String message = String.format(Locale.ROOT, "Check '%s' waits for comment type token ('%s') and should override 'isCommentNodesRequired()' method to return 'true'", check.getClass().getName(), TokenUtil.getTokenName(tokenId));
                throw new CheckstyleException(message);
            }
            this.tokenToOrdinaryChecks.computeIfAbsent(tokenId, empty -> TreeWalker.createNewCheckSortedSet()).add(check);
        }
    }

    private void walk(DetailAST ast, FileContents contents, AstState astState) {
        this.notifyBegin(ast, contents, astState);
        this.processIter(ast, astState);
        this.notifyEnd(ast, astState);
    }

    private void notifyBegin(DetailAST rootAST, FileContents contents, AstState astState) {
        Set<AbstractCheck> checks = astState == AstState.WITH_COMMENTS ? this.commentChecks : this.ordinaryChecks;
        for (AbstractCheck check : checks) {
            check.setFileContents(contents);
            check.clearMessages();
            check.beginTree(rootAST);
        }
    }

    private void notifyEnd(DetailAST rootAST, AstState astState) {
        Set<AbstractCheck> checks = astState == AstState.WITH_COMMENTS ? this.commentChecks : this.ordinaryChecks;
        for (AbstractCheck check : checks) {
            check.finishTree(rootAST);
            this.messages.addAll(check.getMessages());
        }
    }

    private void notifyVisit(DetailAST ast, AstState astState) {
        Collection<AbstractCheck> visitors = this.getListOfChecks(ast, astState);
        if (visitors != null) {
            for (AbstractCheck check : visitors) {
                check.visitToken(ast);
            }
        }
    }

    private void notifyLeave(DetailAST ast, AstState astState) {
        Collection<AbstractCheck> visitors = this.getListOfChecks(ast, astState);
        if (visitors != null) {
            for (AbstractCheck check : visitors) {
                check.leaveToken(ast);
            }
        }
    }

    private Collection<AbstractCheck> getListOfChecks(DetailAST ast, AstState astState) {
        int tokenId = ast.getType();
        Collection visitors = astState == AstState.WITH_COMMENTS ? (Collection)this.tokenToCommentChecks.get(tokenId) : (Collection)this.tokenToOrdinaryChecks.get(tokenId);
        return visitors;
    }

    @Override
    public void destroy() {
        this.ordinaryChecks.forEach(AbstractCheck::destroy);
        this.commentChecks.forEach(AbstractCheck::destroy);
        super.destroy();
    }

    @Override
    public Set<String> getExternalResourceLocations() {
        return Stream.concat(this.filters.stream(), Stream.concat(this.ordinaryChecks.stream(), this.commentChecks.stream())).filter(ExternalResourceHolder.class::isInstance).map(ExternalResourceHolder.class::cast).flatMap(resource -> resource.getExternalResourceLocations().stream()).collect(Collectors.toSet());
    }

    private void processIter(DetailAST root, AstState astState) {
        DetailAST curNode = root;
        while (curNode != null) {
            this.notifyVisit(curNode, astState);
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                this.notifyLeave(curNode, astState);
                toVisit = curNode.getNextSibling();
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    private static SortedSet<AbstractCheck> createNewCheckSortedSet() {
        return new TreeSet<AbstractCheck>(Comparator.comparing(check -> check.getClass().getName()).thenComparing(AbstractViolationReporter::getId, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(Object::hashCode));
    }

    private static enum AstState {
        ORDINARY,
        WITH_COMMENTS;

    }
}

