/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.AstTreeStringPrinter;
import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.RootNode;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.Item;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;

public final class XpathUtil {
    private static final List<Integer> TOKEN_TYPES_WITH_TEXT_ATTRIBUTE = Arrays.asList(58, 139, 138, 141, 137, 142, 140);
    private static final String DELIMITER = "---------" + System.lineSeparator();

    private XpathUtil() {
    }

    public static boolean supportsTextAttribute(DetailAST ast) {
        return TOKEN_TYPES_WITH_TEXT_ATTRIBUTE.contains(ast.getType());
    }

    public static String getTextAttributeValue(DetailAST ast) {
        String text = ast.getText();
        if (ast.getType() == 139) {
            text = text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static String printXpathBranch(String xpath, File file) throws CheckstyleException, IOException {
        XPathEvaluator xpathEvaluator = new XPathEvaluator(Configuration.newConfiguration());
        try {
            RootNode rootNode = new RootNode(JavaParser.parseFile(file, JavaParser.Options.WITH_COMMENTS));
            XPathExpression xpathExpression = xpathEvaluator.createExpression(xpath);
            XPathDynamicContext xpathDynamicContext = xpathExpression.createDynamicContext((Item)rootNode);
            List matchingItems = xpathExpression.evaluate(xpathDynamicContext);
            return matchingItems.stream().map(item -> ((AbstractNode)item).getUnderlyingNode()).map(AstTreeStringPrinter::printBranch).collect(Collectors.joining(DELIMITER));
        }
        catch (XPathException ex) {
            String errMsg = String.format(Locale.ROOT, "Error during evaluation for xpath: %s, file: %s", xpath, file.getCanonicalPath());
            throw new CheckstyleException(errMsg, ex);
        }
    }
}

