// $ANTLR 2.7.7 (20060906): "java14textblocks.g" -> "GeneratedTextBlockLexer.java"$

package com.puppycrawl.tools.checkstyle.grammar;

import com.puppycrawl.tools.checkstyle.DetailAstImpl;
import java.text.MessageFormat;
import antlr.CommonHiddenStreamToken;
import antlr.TokenStreamSelector;

import java.io.InputStream;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.TokenStreamRecognitionException;
import antlr.CharStreamException;
import antlr.CharStreamIOException;
import antlr.ANTLRException;
import java.io.Reader;
import java.util.Hashtable;
import antlr.CharScanner;
import antlr.InputBuffer;
import antlr.ByteBuffer;
import antlr.CharBuffer;
import antlr.Token;
import antlr.CommonToken;
import antlr.RecognitionException;
import antlr.NoViableAltForCharException;
import antlr.MismatchedCharException;
import antlr.TokenStream;
import antlr.ANTLRHashString;
import antlr.LexerSharedInputState;
import antlr.collections.impl.BitSet;
import antlr.SemanticException;

public class GeneratedTextBlockLexer extends antlr.CharScanner implements GeneratedTextBlockLexerTokenTypes, TokenStream
 {

    public TokenStreamSelector selector;

    // explicitly set tab width to 1 (default in ANTLR 2.7.1)
    // in ANTLR 2.7.2a2 the default has changed from 1 to 8
    public void tab()
    {
        setColumn( getColumn() + 1 );
    }
public GeneratedTextBlockLexer(InputStream in) {
	this(new ByteBuffer(in));
}
public GeneratedTextBlockLexer(Reader in) {
	this(new CharBuffer(in));
}
public GeneratedTextBlockLexer(InputBuffer ib) {
	this(new LexerSharedInputState(ib));
}
public GeneratedTextBlockLexer(LexerSharedInputState state) {
	super(state);
	caseSensitiveLiterals = true;
	setCaseSensitive(true);
	literals = new Hashtable();
	literals.put(new ANTLRHashString("byte", this), new Integer(51));
	literals.put(new ANTLRHashString("public", this), new Integer(62));
	literals.put(new ANTLRHashString("case", this), new Integer(93));
	literals.put(new ANTLRHashString("short", this), new Integer(53));
	literals.put(new ANTLRHashString("break", this), new Integer(86));
	literals.put(new ANTLRHashString("while", this), new Integer(84));
	literals.put(new ANTLRHashString("new", this), new Integer(136));
	literals.put(new ANTLRHashString("instanceof", this), new Integer(121));
	literals.put(new ANTLRHashString("implements", this), new Integer(75));
	literals.put(new ANTLRHashString("synchronized", this), new Integer(67));
	literals.put(new ANTLRHashString("float", this), new Integer(55));
	literals.put(new ANTLRHashString("package", this), new Integer(44));
	literals.put(new ANTLRHashString("return", this), new Integer(88));
	literals.put(new ANTLRHashString("throw", this), new Integer(90));
	literals.put(new ANTLRHashString("null", this), new Integer(135));
	literals.put(new ANTLRHashString("protected", this), new Integer(63));
	literals.put(new ANTLRHashString("class", this), new Integer(69));
	literals.put(new ANTLRHashString("throws", this), new Integer(81));
	literals.put(new ANTLRHashString("do", this), new Integer(85));
	literals.put(new ANTLRHashString("strictfp", this), new Integer(41));
	literals.put(new ANTLRHashString("super", this), new Integer(79));
	literals.put(new ANTLRHashString("transient", this), new Integer(65));
	literals.put(new ANTLRHashString("native", this), new Integer(66));
	literals.put(new ANTLRHashString("interface", this), new Integer(71));
	literals.put(new ANTLRHashString("final", this), new Integer(39));
	literals.put(new ANTLRHashString("yield", this), new Integer(207));
	literals.put(new ANTLRHashString("if", this), new Integer(83));
	literals.put(new ANTLRHashString("record", this), new Integer(200));
	literals.put(new ANTLRHashString("double", this), new Integer(57));
	literals.put(new ANTLRHashString("volatile", this), new Integer(68));
	literals.put(new ANTLRHashString("catch", this), new Integer(96));
	literals.put(new ANTLRHashString("try", this), new Integer(95));
	literals.put(new ANTLRHashString("int", this), new Integer(54));
	literals.put(new ANTLRHashString("for", this), new Integer(91));
	literals.put(new ANTLRHashString("extends", this), new Integer(70));
	literals.put(new ANTLRHashString("boolean", this), new Integer(50));
	literals.put(new ANTLRHashString("char", this), new Integer(52));
	literals.put(new ANTLRHashString("private", this), new Integer(61));
	literals.put(new ANTLRHashString("default", this), new Integer(94));
	literals.put(new ANTLRHashString("false", this), new Integer(134));
	literals.put(new ANTLRHashString("this", this), new Integer(78));
	literals.put(new ANTLRHashString("static", this), new Integer(64));
	literals.put(new ANTLRHashString("abstract", this), new Integer(40));
	literals.put(new ANTLRHashString("continue", this), new Integer(87));
	literals.put(new ANTLRHashString("finally", this), new Integer(97));
	literals.put(new ANTLRHashString("else", this), new Integer(92));
	literals.put(new ANTLRHashString("import", this), new Integer(46));
	literals.put(new ANTLRHashString("void", this), new Integer(49));
	literals.put(new ANTLRHashString("switch", this), new Integer(89));
	literals.put(new ANTLRHashString("true", this), new Integer(133));
	literals.put(new ANTLRHashString("long", this), new Integer(56));
}

public Token nextToken() throws TokenStreamException {
	Token theRetToken=null;
tryAgain:
	for (;;) {
		Token _token = null;
		int _ttype = Token.INVALID_TYPE;
		setCommitToPath(false);
		resetText();
		try {   // for char stream error handling
			try {   // for lexical error handling
				if ((LA(1)=='"') && (LA(2)=='"')) {
					mTEXT_BLOCK_LITERAL_END(true);
					theRetToken=_returnToken;
				}
				else if (((LA(1) >= '\u0000' && LA(1) <= '\ufffe')) && (true)) {
					mTEXT_BLOCK_CONTENT(true);
					theRetToken=_returnToken;
				}
				else {
					if (LA(1)==EOF_CHAR) {uponEOF(); _returnToken = makeToken(Token.EOF_TYPE);}
				else {consume(); continue tryAgain;}
				}
				
				if ( _returnToken==null ) continue tryAgain; // found SKIP token
				_ttype = _returnToken.getType();
				_ttype = testLiteralsTable(_ttype);
				_returnToken.setType(_ttype);
				return _returnToken;
			}
			catch (RecognitionException e) {
				if ( !getCommitToPath() ) {consume(); continue tryAgain;}
				throw new TokenStreamRecognitionException(e);
			}
		}
		catch (CharStreamException cse) {
			if ( cse instanceof CharStreamIOException ) {
				throw new TokenStreamIOException(((CharStreamIOException)cse).io);
			}
			else {
				throw new TokenStreamException(cse.getMessage());
			}
		}
	}
}

	protected final void mNEWLINE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = NEWLINE;
		int _saveIndex;
		
		{
		if ((LA(1)=='\r') && (LA(2)=='\n')) {
			match("\r\n");
		}
		else if ((LA(1)=='\r') && (true)) {
			match('\r');
		}
		else if ((LA(1)=='\n')) {
			match('\n');
		}
		else {
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		
		}
		if ( inputState.guessing==0 ) {
			this.newline();
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mTEXT_BLOCK_LITERAL_END(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = TEXT_BLOCK_LITERAL_END;
		int _saveIndex;
		
		match("\"\"\"");
		if ( inputState.guessing==0 ) {
			selector.pop();
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mTWO_DOUBLE_QUOTES(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = TWO_DOUBLE_QUOTES;
		int _saveIndex;
		
		match('"');
		match('"');
		{
		if ((LA(1)=='\n'||LA(1)=='\r')) {
			mNEWLINE(false);
		}
		else if ((_tokenSet_0.member(LA(1)))) {
			matchNot('"');
		}
		else {
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mONE_DOUBLE_QUOTE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = ONE_DOUBLE_QUOTE;
		int _saveIndex;
		
		match('"');
		{
		if ((LA(1)=='\n'||LA(1)=='\r')) {
			mNEWLINE(false);
		}
		else if ((_tokenSet_0.member(LA(1)))) {
			matchNot('"');
		}
		else {
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mTEXT_BLOCK_CONTENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = TEXT_BLOCK_CONTENT;
		int _saveIndex;
		
		{
		int _cnt12=0;
		_loop12:
		do {
			boolean synPredMatched11 = false;
			if (((LA(1)=='"') && (LA(2)=='"'))) {
				int _m11 = mark();
				synPredMatched11 = true;
				inputState.guessing++;
				try {
					{
					mTWO_DOUBLE_QUOTES(false);
					}
				}
				catch (RecognitionException pe) {
					synPredMatched11 = false;
				}
				rewind(_m11);
inputState.guessing--;
			}
			if ( synPredMatched11 ) {
				mTWO_DOUBLE_QUOTES(false);
			}
			else if ((LA(1)=='"') && (_tokenSet_1.member(LA(2)))) {
				mONE_DOUBLE_QUOTE(false);
			}
			else if ((LA(1)=='\\') && (_tokenSet_2.member(LA(2)))) {
				mSTD_ESC(false);
			}
			else if ((LA(1)=='\n'||LA(1)=='\r')) {
				mNEWLINE(false);
			}
			else if ((_tokenSet_0.member(LA(1))) && (true)) {
				matchNot('"');
			}
			else {
				if ( _cnt12>=1 ) { break _loop12; } else {throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());}
			}
			
			_cnt12++;
		} while (true);
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mSTD_ESC(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = STD_ESC;
		int _saveIndex;
		
		match('\\');
		{
		switch ( LA(1)) {
		case 'n':
		{
			match('n');
			break;
		}
		case 'r':
		{
			match('r');
			break;
		}
		case 's':
		{
			match('s');
			break;
		}
		case 't':
		{
			match('t');
			break;
		}
		case 'b':
		{
			match('b');
			break;
		}
		case 'f':
		{
			match('f');
			break;
		}
		case '"':
		{
			match('"');
			break;
		}
		case '\'':
		{
			match('\'');
			break;
		}
		case '\\':
		{
			match('\\');
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		}
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	
	private static final long[] mk_tokenSet_0() {
		long[] data = new long[2048];
		data[0]=-17179878401L;
		for (int i = 1; i<=1022; i++) { data[i]=-1L; }
		data[1023]=9223372036854775807L;
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = new long[2048];
		data[0]=-17179869185L;
		for (int i = 1; i<=1022; i++) { data[i]=-1L; }
		data[1023]=9223372036854775807L;
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	private static final long[] mk_tokenSet_2() {
		long[] data = new long[1025];
		data[0]=566935683072L;
		data[1]=7951960418287616L;
		return data;
	}
	public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
	
	}
