/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.util.List;

public class CodeSelectorPresentation {
    private final Object node;
    private final List<Integer> lines2position;
    private int selectionStart;
    private int selectionEnd;

    public CodeSelectorPresentation(DetailAST ast, List<Integer> lines2position) {
        this.node = ast;
        this.lines2position = lines2position;
    }

    public CodeSelectorPresentation(DetailNode node, List<Integer> lines2position) {
        this.node = node;
        this.lines2position = lines2position;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public void findSelectionPositions() {
        if (this.node instanceof DetailAST) {
            this.findSelectionPositions((DetailAST)((Object)this.node));
        } else {
            this.findSelectionPositions((DetailNode)this.node);
        }
    }

    private void findSelectionPositions(DetailAST ast) {
        this.selectionStart = this.lines2position.get(ast.getLineNo()) + ast.getColumnNo();
        this.selectionEnd = ast.getChildCount() == 0 && TokenUtils.getTokenName(ast.getType()).equals(ast.getText()) ? this.selectionStart : this.findLastPosition(ast);
    }

    private void findSelectionPositions(DetailNode detailNode) {
        this.selectionStart = this.lines2position.get(detailNode.getLineNumber()) + detailNode.getColumnNumber();
        this.selectionEnd = this.findLastPosition(detailNode);
    }

    private int findLastPosition(DetailAST astNode) {
        int lastPosition = astNode.getChildCount() == 0 ? this.lines2position.get(astNode.getLineNo()) + astNode.getColumnNo() + astNode.getText().length() : this.findLastPosition(astNode.getLastChild());
        return lastPosition;
    }

    private int findLastPosition(DetailNode detailNode) {
        int lastPosition;
        if (detailNode.getChildren().length == 0) {
            lastPosition = this.lines2position.get(detailNode.getLineNumber()) + detailNode.getColumnNumber() + detailNode.getText().length();
        } else {
            DetailNode lastChild = detailNode.getChildren()[detailNode.getChildren().length - 1];
            lastPosition = this.findLastPosition(lastChild);
        }
        return lastPosition;
    }
}

