/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.regex.Pattern;

@StatelessCheck
public class IllegalTokenTextCheck
extends AbstractCheck {
    public static final String MSG_KEY = "illegal.token.text";
    private String message = "";
    private String formatString = "$^";
    private Pattern format = Pattern.compile(this.formatString);
    private boolean ignoreCase;

    @Override
    public int[] getDefaultTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{142, 140, 137, 141, 58, 183, 139, 138};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public void visitToken(DetailAST ast) {
        String text = ast.getText();
        if (this.format.matcher(text).find()) {
            String customMessage = this.message;
            if (customMessage.isEmpty()) {
                customMessage = MSG_KEY;
            }
            this.log(ast, customMessage, this.formatString);
        }
    }

    public void setMessage(String message) {
        this.message = message == null ? "" : message;
    }

    public void setFormat(String format) {
        this.formatString = format;
        this.updateRegexp();
    }

    public void setIgnoreCase(boolean caseInsensitive) {
        this.ignoreCase = caseInsensitive;
        this.updateRegexp();
    }

    private void updateRegexp() {
        int compileFlags = this.ignoreCase ? 2 : 0;
        this.format = CommonUtils.createPattern(this.formatString, compileFlags);
    }
}

