/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import java.util.HashMap;
import java.util.Map;

@FileStatefulCheck
public class EqualsHashCodeCheck
extends AbstractCheck {
    public static final String MSG_KEY_HASHCODE = "equals.noHashCode";
    public static final String MSG_KEY_EQUALS = "equals.noEquals";
    private final Map<DetailAST, DetailAST> objBlockWithEquals = new HashMap<DetailAST, DetailAST>();
    private final Map<DetailAST, DetailAST> objBlockWithHashCode = new HashMap<DetailAST, DetailAST>();

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{9};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.objBlockWithEquals.clear();
        this.objBlockWithHashCode.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (EqualsHashCodeCheck.isEqualsMethod(ast)) {
            this.objBlockWithEquals.put(ast.getParent(), ast);
        } else if (EqualsHashCodeCheck.isHashCodeMethod(ast)) {
            this.objBlockWithHashCode.put(ast.getParent(), ast);
        }
    }

    private static boolean isEqualsMethod(DetailAST ast) {
        DetailAST modifiers = ast.getFirstChild();
        DetailAST parameters = ast.findFirstToken(20);
        return CheckUtils.isEqualsMethod(ast) && modifiers.findFirstToken(62) != null && EqualsHashCodeCheck.isObjectParam(parameters.getFirstChild()) && (ast.findFirstToken(7) != null || modifiers.findFirstToken(66) != null);
    }

    private static boolean isHashCodeMethod(DetailAST ast) {
        DetailAST modifiers = ast.getFirstChild();
        DetailAST type = ast.findFirstToken(13);
        DetailAST methodName = ast.findFirstToken(58);
        DetailAST parameters = ast.findFirstToken(20);
        return type.getFirstChild().getType() == 54 && "hashCode".equals(methodName.getText()) && modifiers.findFirstToken(62) != null && modifiers.findFirstToken(64) == null && parameters.getFirstChild() == null && (ast.findFirstToken(7) != null || modifiers.findFirstToken(66) != null);
    }

    private static boolean isObjectParam(DetailAST paramNode) {
        DetailAST typeNode = paramNode.findFirstToken(13);
        FullIdent fullIdent = FullIdent.createFullIdentBelow(typeNode);
        String name = fullIdent.getText();
        return "Object".equals(name) || "java.lang.Object".equals(name);
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        this.objBlockWithEquals.entrySet().stream().filter(detailASTDetailASTEntry -> this.objBlockWithHashCode.remove(detailASTDetailASTEntry.getKey()) == null).forEach(detailASTDetailASTEntry -> {
            DetailAST equalsAST = (DetailAST)((Object)((Object)detailASTDetailASTEntry.getValue()));
            this.log(equalsAST, MSG_KEY_HASHCODE, new Object[0]);
        });
        this.objBlockWithHashCode.forEach((key, equalsAST) -> this.log((DetailAST)((Object)equalsAST), MSG_KEY_EQUALS, new Object[0]));
    }
}

