/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import java.util.HashSet;
import java.util.Set;

@FileStatefulCheck
public class CovariantEqualsCheck
extends AbstractCheck {
    public static final String MSG_KEY = "covariant.equals";
    private final Set<DetailAST> equalsMethods = new HashSet<DetailAST>();

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14, 136, 154};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        this.equalsMethods.clear();
        DetailAST objBlock = ast.findFirstToken(6);
        if (objBlock != null) {
            boolean hasEqualsObject = false;
            for (DetailAST child = objBlock.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 9 || !CheckUtils.isEqualsMethod(child)) continue;
                if (CovariantEqualsCheck.isFirstParameterObject(child)) {
                    hasEqualsObject = true;
                    continue;
                }
                this.equalsMethods.add(child);
            }
            if (!hasEqualsObject) {
                for (DetailAST equalsAST : this.equalsMethods) {
                    DetailAST nameNode = equalsAST.findFirstToken(58);
                    this.log(nameNode, MSG_KEY, new Object[0]);
                }
            }
        }
    }

    private static boolean isFirstParameterObject(DetailAST methodDefAst) {
        DetailAST paramsNode = methodDefAst.findFirstToken(20);
        DetailAST paramNode = paramsNode.findFirstToken(21);
        DetailAST typeNode = paramNode.findFirstToken(13);
        FullIdent fullIdent = FullIdent.createFullIdentBelow(typeNode);
        String name = fullIdent.getText();
        return "Object".equals(name) || "java.lang.Object".equals(name);
    }
}

