/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.DetailNodeTreeStringPrinter;
import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class JavadocPropertiesGenerator {
    private static final String OPTION_DEST_FILE = "destfile";
    private static final int HELP_WIDTH = 100;
    private static final Pattern END_OF_SENTENCE_PATTERN = Pattern.compile("(.*?[.?!])(\\s|$)");

    private JavadocPropertiesGenerator() {
    }

    public static void main(String ... args) throws CheckstyleException, ParseException {
        CommandLine commandLine = JavadocPropertiesGenerator.parseCli(args);
        if (commandLine.getArgList().size() == 1) {
            File inputFile = new File((String)commandLine.getArgList().get(0));
            File outputFile = new File(commandLine.getOptionValue(OPTION_DEST_FILE));
            JavadocPropertiesGenerator.writePropertiesFile(inputFile, outputFile);
        } else {
            JavadocPropertiesGenerator.printUsage();
        }
    }

    private static void writePropertiesFile(File inputFile, File outputFile) throws CheckstyleException {
        try (PrintWriter writer = new PrintWriter(outputFile, StandardCharsets.UTF_8.name());){
            DetailAST top = JavaParser.parseFile(inputFile, JavaParser.Options.WITH_COMMENTS);
            DetailAST objBlock = JavadocPropertiesGenerator.getClassBody(top);
            if (objBlock != null) {
                JavadocPropertiesGenerator.iteratePublicStaticIntFields(objBlock, writer::println);
            }
        }
        catch (IOException ex) {
            throw new CheckstyleException("Failed to write javadoc properties of '" + inputFile + "' to '" + outputFile + "'", ex);
        }
    }

    private static void iteratePublicStaticIntFields(DetailAST objBlock, Consumer<String> consumer) throws CheckstyleException {
        for (DetailAST member = objBlock.getFirstChild(); member != null; member = member.getNextSibling()) {
            DetailAST modifiers;
            String firstJavadocSentence;
            if (!JavadocPropertiesGenerator.isPublicStaticFinalIntField(member) || (firstJavadocSentence = JavadocPropertiesGenerator.getFirstJavadocSentence(modifiers = member.findFirstToken(5))) == null) continue;
            consumer.accept(JavadocPropertiesGenerator.getName(member) + "=" + firstJavadocSentence.trim());
        }
    }

    private static DetailAST getClassBody(DetailAST top) {
        DetailAST ast;
        for (ast = top; ast != null && ast.getType() != 14; ast = ast.getNextSibling()) {
        }
        DetailAST objBlock = null;
        if (ast != null) {
            objBlock = ast.findFirstToken(6);
        }
        return objBlock;
    }

    private static boolean isPublicStaticFinalIntField(DetailAST ast) {
        boolean result;
        boolean bl = result = ast.getType() == 10;
        if (result) {
            DetailAST type = ast.findFirstToken(13);
            boolean bl2 = result = type.getFirstChild().getType() == 54;
            if (result) {
                DetailAST modifiers = ast.findFirstToken(5);
                result = modifiers.findFirstToken(62) != null && modifiers.findFirstToken(64) != null && modifiers.findFirstToken(39) != null;
            }
        }
        return result;
    }

    private static String getName(DetailAST ast) {
        return ast.findFirstToken(58).getText();
    }

    private static String getFirstJavadocSentence(DetailAST ast) throws CheckstyleException {
        String firstSentence = null;
        for (DetailAST child = ast.getFirstChild(); child != null && firstSentence == null; child = child.getNextSibling()) {
            if (child.getType() == 159) {
                firstSentence = JavadocPropertiesGenerator.getFirstJavadocSentence(child);
                continue;
            }
            if (child.getType() != 145 || !JavadocUtils.isJavadocComment(child)) continue;
            DetailNode tree = DetailNodeTreeStringPrinter.parseJavadocAsDetailNode(child);
            firstSentence = JavadocPropertiesGenerator.getFirstJavadocSentence(tree);
        }
        return firstSentence;
    }

    private static String getFirstJavadocSentence(DetailNode tree) throws CheckstyleException {
        String firstSentence = null;
        StringBuilder builder = new StringBuilder(128);
        for (DetailNode node : tree.getChildren()) {
            if (node.getType() == 10074) {
                Matcher matcher = END_OF_SENTENCE_PATTERN.matcher(node.getText());
                if (matcher.find()) {
                    firstSentence = builder.append(matcher.group(1)).toString();
                    break;
                }
                builder.append(node.getText());
                continue;
            }
            if (node.getType() == 10072) {
                JavadocPropertiesGenerator.formatInlineCodeTag(builder, node);
                continue;
            }
            if (node.getType() != 10001) continue;
            JavadocPropertiesGenerator.formatHtmlElement(builder, node);
        }
        return firstSentence;
    }

    private static void formatInlineCodeTag(StringBuilder builder, DetailNode inlineTag) throws CheckstyleException {
        boolean wrapWithCodeTag = false;
        block5: for (DetailNode node : inlineTag.getChildren()) {
            switch (node.getType()) {
                case 45: {
                    wrapWithCodeTag = true;
                    continue block5;
                }
                case 10074: {
                    if (wrapWithCodeTag) {
                        builder.append("<code>").append(node.getText()).append("</code>");
                        continue block5;
                    }
                    builder.append(node.getText());
                    continue block5;
                }
                case 4: 
                case 19: 
                case 20: 
                case 50: {
                    continue block5;
                }
                default: {
                    throw new CheckstyleException("Unsupported inline tag " + JavadocUtils.getTokenName(node.getType()));
                }
            }
        }
    }

    private static void formatHtmlElement(StringBuilder builder, DetailNode node) {
        switch (node.getType()) {
            case 5: 
            case 55: 
            case 57: 
            case 95: 
            case 10074: {
                builder.append(node.getText());
                break;
            }
            default: {
                for (DetailNode child : node.getChildren()) {
                    JavadocPropertiesGenerator.formatHtmlElement(builder, child);
                }
            }
        }
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(100);
        formatter.printHelp(String.format("java %s [options] <input file>.", JavadocPropertiesGenerator.class.getName()), JavadocPropertiesGenerator.buildOptions());
    }

    private static CommandLine parseCli(String ... args) throws ParseException {
        DefaultParser clp = new DefaultParser();
        return clp.parse(JavadocPropertiesGenerator.buildOptions(), args);
    }

    private static Options buildOptions() {
        Options options = new Options();
        options.addRequiredOption(null, OPTION_DEST_FILE, true, "The output file.");
        return options;
    }
}

