/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;

public class WhitespaceAfterCheck
extends AbstractCheck {
    public static final String MSG_WS_NOT_FOLLOWED = "ws.notFollowed";
    public static final String MSG_WS_TYPECAST = "ws.typeCast";

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{74, 45, 23, 83, 92, 84, 85, 91, 175};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 23) {
            String line;
            DetailAST targetAST = ast.findFirstToken(77);
            if (!WhitespaceAfterCheck.isFollowedByWhitespace(targetAST, line = this.getLine(targetAST.getLineNo() - 1))) {
                this.log(targetAST.getLineNo(), targetAST.getColumnNo() + targetAST.getText().length(), MSG_WS_TYPECAST, new Object[0]);
            }
        } else {
            String line = this.getLine(ast.getLineNo() - 1);
            if (!WhitespaceAfterCheck.isFollowedByWhitespace(ast, line)) {
                Object[] message = new Object[]{ast.getText()};
                this.log(ast.getLineNo(), ast.getColumnNo() + ast.getText().length(), MSG_WS_NOT_FOLLOWED, message);
            }
        }
    }

    private static boolean isFollowedByWhitespace(DetailAST targetAST, String line) {
        int after = targetAST.getColumnNo() + targetAST.getText().length();
        boolean followedByWhitespace = true;
        if (after < line.length()) {
            char charAfter = line.charAt(after);
            followedByWhitespace = charAfter == ';' || charAfter == ')' || Character.isWhitespace(charAfter);
        }
        return followedByWhitespace;
    }
}

