/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;

public class NoWhitespaceBeforeCheck
extends AbstractCheck {
    public static final String MSG_KEY = "ws.preceded";
    private boolean allowLineBreaks;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{74, 45, 25, 26, 171};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{74, 45, 25, 26, 59, 172, 173, 171};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        String line = this.getLine(ast.getLineNo() - 1);
        int before = ast.getColumnNo() - 1;
        if ((before < 0 || Character.isWhitespace(line.charAt(before))) && !NoWhitespaceBeforeCheck.isInEmptyForInitializer(ast)) {
            boolean flag = !this.allowLineBreaks;
            for (int i = 0; !flag && i < before; ++i) {
                if (Character.isWhitespace(line.charAt(i))) continue;
                flag = true;
            }
            if (flag) {
                this.log(ast.getLineNo(), before, MSG_KEY, ast.getText());
            }
        }
    }

    private static boolean isInEmptyForInitializer(DetailAST semicolonAst) {
        DetailAST sibling;
        boolean result = false;
        if (semicolonAst.getType() == 45 && (sibling = semicolonAst.getPreviousSibling()) != null && sibling.getType() == 35 && sibling.getChildCount() == 0) {
            result = true;
        }
        return result;
    }

    public void setAllowLineBreaks(boolean allowLineBreaks) {
        this.allowLineBreaks = allowLineBreaks;
    }
}

