/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.regexp;

import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.checks.regexp.MatchSuppressor;
import com.puppycrawl.tools.checkstyle.checks.regexp.NeverSuppress;
import java.util.Optional;
import java.util.regex.Pattern;

public final class DetectorOptions {
    private int compileFlags;
    private AbstractViolationReporter reporter;
    private String format;
    private String message = "";
    private int minimum;
    private int maximum;
    private boolean ignoreCase;
    private MatchSuppressor suppressor;
    private Pattern pattern;

    private DetectorOptions() {
    }

    public static Builder newBuilder() {
        return new DetectorOptions().new Builder();
    }

    public String getFormat() {
        return this.format;
    }

    public AbstractViolationReporter getReporter() {
        return this.reporter;
    }

    public String getMessage() {
        return this.message;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public MatchSuppressor getSuppressor() {
        return this.suppressor;
    }

    public Pattern getPattern() {
        if (this.pattern != null) {
            return this.pattern;
        }
        int options = this.compileFlags;
        if (this.ignoreCase) {
            options |= 2;
        }
        this.pattern = Pattern.compile(this.format, options);
        return this.pattern;
    }

    public final class Builder {
        public Builder reporter(AbstractViolationReporter val) {
            DetectorOptions.this.reporter = val;
            return this;
        }

        public Builder compileFlags(int val) {
            DetectorOptions.this.compileFlags = val;
            return this;
        }

        public Builder format(String val) {
            DetectorOptions.this.format = val;
            return this;
        }

        public Builder message(String val) {
            DetectorOptions.this.message = val;
            return this;
        }

        public Builder minimum(int val) {
            DetectorOptions.this.minimum = val;
            return this;
        }

        public Builder maximum(int val) {
            DetectorOptions.this.maximum = val;
            return this;
        }

        public Builder ignoreCase(boolean val) {
            DetectorOptions.this.ignoreCase = val;
            return this;
        }

        public Builder suppressor(MatchSuppressor val) {
            DetectorOptions.this.suppressor = val;
            return this;
        }

        public DetectorOptions build() {
            DetectorOptions.this.message = Optional.ofNullable(DetectorOptions.this.message).orElse("");
            DetectorOptions.this.suppressor = Optional.ofNullable(DetectorOptions.this.suppressor).orElse(NeverSuppress.INSTANCE);
            return DetectorOptions.this;
        }
    }
}

