/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractAccessControlNameCheck;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;

public class MemberNameCheck
extends AbstractAccessControlNameCheck {
    public MemberNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    protected final boolean mustCheckName(DetailAST ast) {
        DetailAST modifiersAST = ast.findFirstToken(5);
        boolean isStatic = modifiersAST.branchContains(64);
        return !isStatic && !ScopeUtils.isInInterfaceOrAnnotationBlock(ast) && !ScopeUtils.isLocalVariableDef(ast) && this.shouldCheckInScope(modifiersAST);
    }
}

