/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashMap;

public class OverloadMethodsDeclarationOrderCheck
extends AbstractCheck {
    public static final String MSG_KEY = "overload.methods.declaration";

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{6};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        int parentType = ast.getParent().getType();
        if (parentType == 14 || parentType == 154 || parentType == 15 || parentType == 136) {
            this.checkOverloadMethodsGrouping(ast);
        }
    }

    private void checkOverloadMethodsGrouping(DetailAST objectBlock) {
        boolean allowedDistance = true;
        HashMap<String, Integer> methodIndexMap = new HashMap<String, Integer>();
        HashMap<String, Integer> methodLineNumberMap = new HashMap<String, Integer>();
        int currentIndex = 0;
        for (DetailAST currentToken = objectBlock.getFirstChild(); currentToken != null; currentToken = currentToken.getNextSibling()) {
            int previousIndex;
            if (currentToken.getType() != 9) continue;
            String methodName = currentToken.findFirstToken(58).getText();
            if (methodIndexMap.containsKey(methodName) && ++currentIndex - (previousIndex = ((Integer)methodIndexMap.get(methodName)).intValue()) > 1) {
                int previousLineWithOverloadMethod = (Integer)methodLineNumberMap.get(methodName);
                this.log(currentToken.getLineNo(), MSG_KEY, previousLineWithOverloadMethod);
            }
            methodIndexMap.put(methodName, currentIndex);
            methodLineNumberMap.put(methodName, currentToken.getLineNo());
        }
    }
}

