/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;

public class DesignForExtensionCheck
extends Check {
    public static final String MSG_KEY = "design.forExtension";

    @Override
    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ScopeUtils.inInterfaceOrAnnotationBlock(ast)) {
            return;
        }
        if (this.isPrivateOrFinalOrAbstract(ast)) {
            return;
        }
        if (!ScopeUtils.getSurroundingScope(ast).isIn(Scope.PROTECTED)) {
            return;
        }
        DetailAST implementation = ast.findFirstToken(7);
        if (implementation != null && implementation.getFirstChild().getType() == 73) {
            return;
        }
        DetailAST classDef = this.findContainingClass(ast);
        DetailAST classMods = classDef.findFirstToken(5);
        if (classDef.getType() == 154 || classMods.branchContains(39)) {
            return;
        }
        if (this.hasDefaultOrExplNonPrivateCtor(classDef)) {
            String name = ast.findFirstToken(58).getText();
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, name);
        }
    }

    private boolean isPrivateOrFinalOrAbstract(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        return modifiers.branchContains(61) || modifiers.branchContains(40) || modifiers.branchContains(39) || modifiers.branchContains(64);
    }

    private boolean hasDefaultOrExplNonPrivateCtor(DetailAST classDef) {
        DetailAST objBlock = classDef.findFirstToken(6);
        boolean hasDefaultConstructor = true;
        boolean hasExplNonPrivateCtor = false;
        for (DetailAST candidate = objBlock.getFirstChild(); candidate != null; candidate = candidate.getNextSibling()) {
            if (candidate.getType() != 8) continue;
            hasDefaultConstructor = false;
            DetailAST ctorMods = candidate.findFirstToken(5);
            if (ctorMods.branchContains(61)) continue;
            hasExplNonPrivateCtor = true;
            break;
        }
        return hasDefaultConstructor || hasExplNonPrivateCtor;
    }

    private DetailAST findContainingClass(DetailAST ast) {
        DetailAST searchAST = ast;
        while (searchAST.getType() != 14 && searchAST.getType() != 154) {
            searchAST = searchAST.getParent();
        }
        return searchAST;
    }
}

