/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.checks.LineSeparatorOption;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;

public class NewlineAtEndOfFileCheck
extends AbstractFileSetCheck {
    public static final String MSG_KEY_UNABLE_OPEN = "unable.open";
    public static final String MSG_KEY_NO_NEWLINE_EOF = "noNewlineAtEOF";
    private LineSeparatorOption lineSeparator = LineSeparatorOption.SYSTEM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFiltered(File file, List<String> lines) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            boolean threw = true;
            try {
                if (!this.endsWithNewline(randomAccessFile)) {
                    this.log(0, MSG_KEY_NO_NEWLINE_EOF, file.getPath());
                }
                threw = false;
            }
            finally {
                Closeables.close((Closeable)randomAccessFile, (boolean)threw);
            }
        }
        catch (IOException e) {
            this.log(0, MSG_KEY_UNABLE_OPEN, file.getPath());
        }
    }

    public void setLineSeparator(String lineSeparatorParam) {
        try {
            this.lineSeparator = Enum.valueOf(LineSeparatorOption.class, lineSeparatorParam.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("unable to parse " + lineSeparatorParam, (Throwable)iae);
        }
    }

    private boolean endsWithNewline(RandomAccessFile randomAccessFile) throws IOException {
        int len = this.lineSeparator.length();
        if (randomAccessFile.length() < (long)len) {
            return false;
        }
        randomAccessFile.seek(randomAccessFile.length() - (long)len);
        byte[] lastBytes = new byte[len];
        int readBytes = randomAccessFile.read(lastBytes);
        if (readBytes != len) {
            throw new IOException("Unable to read " + len + " bytes, got " + readBytes);
        }
        return this.lineSeparator.matches(lastBytes);
    }
}

