/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import java.util.regex.Pattern;

public class JavadocVariableCheck
extends Check {
    private Scope mScope = Scope.PRIVATE;
    private Scope mExcludeScope;
    private String mIgnoreNameRegexp;
    private Pattern mIgnoreNamePattern;

    public void setScope(String aFrom) {
        this.mScope = Scope.getInstance(aFrom);
    }

    public void setExcludeScope(String aScope) {
        this.mExcludeScope = Scope.getInstance(aScope);
    }

    public void setIgnoreNamePattern(String aRegexp) {
        this.mIgnoreNameRegexp = aRegexp;
        this.mIgnoreNamePattern = aRegexp != null && aRegexp.length() != 0 ? Pattern.compile(aRegexp) : null;
    }

    public String getIgnoreNamePattern() {
        return this.mIgnoreNameRegexp;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{10, 155};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        FileContents contents;
        TextBlock cmt;
        if (this.shouldCheck(aAST) && (cmt = (contents = this.getFileContents()).getJavadocBefore(aAST.getLineNo())) == null) {
            this.log(aAST, "javadoc.missing", new Object[0]);
        }
    }

    private boolean isIgnored(DetailAST aAST) {
        String name = aAST.findFirstToken(58).getText();
        return this.mIgnoreNamePattern != null && this.mIgnoreNamePattern.matcher(name).matches();
    }

    private boolean shouldCheck(DetailAST aAST) {
        Scope scope;
        if (ScopeUtils.inCodeBlock(aAST) || this.isIgnored(aAST)) {
            return false;
        }
        if (aAST.getType() == 155) {
            scope = Scope.PUBLIC;
        } else {
            DetailAST mods = aAST.findFirstToken(5);
            Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
            scope = ScopeUtils.inInterfaceOrAnnotationBlock(aAST) ? Scope.PUBLIC : declaredScope;
        }
        Scope surroundingScope = ScopeUtils.getSurroundingScope(aAST);
        return scope.isIn(this.mScope) && surroundingScope.isIn(this.mScope) && (this.mExcludeScope == null || !scope.isIn(this.mExcludeScope) || !surroundingScope.isIn(this.mExcludeScope));
    }
}

