/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.ArrayInitHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.CaseHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.CatchHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ClassDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.DoWhileHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ElseHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.FinallyHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ForHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IfHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ImportHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndexHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.LabelHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.MemberDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.MethodCallHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.MethodDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.NewHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ObjectBlockHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.PackageDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.SlistHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.StaticInitHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.SwitchHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.TryHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.WhileHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HandlerFactory {
    private static final Log LOG = LogFactory.getLog((String)"com.puppycrawl.tools.checkstyle.checks.indentation");
    private final Map<Integer, Constructor<?>> mTypeHandlers = Maps.newHashMap();
    private final Map<DetailAST, ExpressionHandler> mCreatedHandlers = Maps.newHashMap();

    private void register(int aType, Class<?> aHandlerClass) {
        try {
            Constructor<?> ctor = aHandlerClass.getConstructor(IndentationCheck.class, DetailAST.class, ExpressionHandler.class);
            this.mTypeHandlers.put(aType, ctor);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("couldn't find ctor for " + aHandlerClass);
        }
        catch (SecurityException e) {
            LOG.debug((Object)("couldn't find ctor for " + aHandlerClass), (Throwable)e);
            throw new RuntimeException("couldn't find ctor for " + aHandlerClass);
        }
    }

    public HandlerFactory() {
        this.register(33, CaseHandler.class);
        this.register(89, SwitchHandler.class);
        this.register(7, SlistHandler.class);
        this.register(16, PackageDefHandler.class);
        this.register(92, ElseHandler.class);
        this.register(83, IfHandler.class);
        this.register(95, TryHandler.class);
        this.register(96, CatchHandler.class);
        this.register(97, FinallyHandler.class);
        this.register(85, DoWhileHandler.class);
        this.register(84, WhileHandler.class);
        this.register(91, ForHandler.class);
        this.register(9, MethodDefHandler.class);
        this.register(8, MethodDefHandler.class);
        this.register(14, ClassDefHandler.class);
        this.register(154, ClassDefHandler.class);
        this.register(6, ObjectBlockHandler.class);
        this.register(15, ClassDefHandler.class);
        this.register(30, ImportHandler.class);
        this.register(29, ArrayInitHandler.class);
        this.register(27, MethodCallHandler.class);
        this.register(43, MethodCallHandler.class);
        this.register(22, LabelHandler.class);
        this.register(12, StaticInitHandler.class);
        this.register(11, SlistHandler.class);
        this.register(10, MemberDefHandler.class);
        this.register(136, NewHandler.class);
        this.register(24, IndexHandler.class);
    }

    public boolean isHandledType(int aType) {
        Set<Integer> typeSet = this.mTypeHandlers.keySet();
        return typeSet.contains(aType);
    }

    public int[] getHandledTypes() {
        Set<Integer> typeSet = this.mTypeHandlers.keySet();
        int[] types = new int[typeSet.size()];
        int index = 0;
        for (Integer val : typeSet) {
            types[index++] = val;
        }
        return types;
    }

    public ExpressionHandler getHandler(IndentationCheck aIndentCheck, DetailAST aAst, ExpressionHandler aParent) {
        ExpressionHandler handler = this.mCreatedHandlers.get((Object)aAst);
        if (handler != null) {
            return handler;
        }
        if (aAst.getType() == 27) {
            return this.createMethodCallHandler(aIndentCheck, aAst, aParent);
        }
        ExpressionHandler expHandler = null;
        try {
            Constructor<?> handlerCtor = this.mTypeHandlers.get(aAst.getType());
            if (handlerCtor != null) {
                expHandler = (ExpressionHandler)handlerCtor.newInstance(new Object[]{aIndentCheck, aAst, aParent});
            }
        }
        catch (InstantiationException e) {
            LOG.debug((Object)("couldn't instantiate constructor for " + (Object)((Object)aAst)), (Throwable)e);
            throw new RuntimeException("couldn't instantiate constructor for " + (Object)((Object)aAst));
        }
        catch (IllegalAccessException e) {
            LOG.debug((Object)("couldn't access constructor for " + (Object)((Object)aAst)), (Throwable)e);
            throw new RuntimeException("couldn't access constructor for " + (Object)((Object)aAst));
        }
        catch (InvocationTargetException e) {
            LOG.debug((Object)("couldn't instantiate constructor for " + (Object)((Object)aAst)), (Throwable)e);
            throw new RuntimeException("couldn't instantiate constructor for " + (Object)((Object)aAst));
        }
        if (expHandler == null) {
            throw new RuntimeException("no handler for type " + aAst.getType());
        }
        return expHandler;
    }

    ExpressionHandler createMethodCallHandler(IndentationCheck aIndentCheck, DetailAST aAst, ExpressionHandler aParent) {
        DetailAST ast;
        ExpressionHandler theParent = aParent;
        for (ast = aAst.getFirstChild(); ast != null && ast.getType() == 59; ast = ast.getFirstChild()) {
        }
        if (ast != null && this.isHandledType(ast.getType())) {
            theParent = this.getHandler(aIndentCheck, ast, theParent);
            this.mCreatedHandlers.put(ast, theParent);
        }
        return new MethodCallHandler(aIndentCheck, aAst, theParent);
    }

    void clearCreatedHandlers() {
        this.mCreatedHandlers.clear();
    }
}

