/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;

public final class MutableExceptionCheck
extends AbstractFormatCheck {
    private static final String DEFAULT_FORMAT = "^.*Exception$|^.*Error$|^.*Throwable$";
    private String mExtendedClassNameFormat;
    private final FastStack<Boolean> mCheckingStack = FastStack.newInstance();
    private boolean mChecking;

    public MutableExceptionCheck() {
        super(DEFAULT_FORMAT);
        this.setExtendedClassNameFormat(DEFAULT_FORMAT);
    }

    public void setExtendedClassNameFormat(String aExtendedClassNameFormat) {
        this.mExtendedClassNameFormat = aExtendedClassNameFormat;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 10};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 14: {
                this.visitClassDef(aAST);
                break;
            }
            case 10: {
                this.visitVariableDef(aAST);
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    @Override
    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 14: {
                this.leaveClassDef();
                break;
            }
        }
    }

    private void visitClassDef(DetailAST aAST) {
        this.mCheckingStack.push(this.mChecking ? Boolean.TRUE : Boolean.FALSE);
        this.mChecking = this.isNamedAsException(aAST) && this.isExtendedClassNamedAsException(aAST);
    }

    private void leaveClassDef() {
        this.mChecking = this.mCheckingStack.pop();
    }

    private void visitVariableDef(DetailAST aAST) {
        DetailAST modifiersAST;
        if (this.mChecking && aAST.getParent().getType() == 6 && (modifiersAST = aAST.findFirstToken(5)).findFirstToken(39) == null) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "mutable.exception", aAST.findFirstToken(58).getText());
        }
    }

    private boolean isNamedAsException(DetailAST aAST) {
        String className = aAST.findFirstToken(58).getText();
        return this.getRegexp().matcher(className).find();
    }

    private boolean isExtendedClassNamedAsException(DetailAST aAST) {
        DetailAST extendedClass;
        DetailAST extendsClause = aAST.findFirstToken(18);
        if (extendsClause != null && (extendedClass = extendsClause.findFirstToken(58)) != null) {
            String extendedClassName = extendedClass.getText();
            return extendedClassName.matches(this.mExtendedClassNameFormat);
        }
        return false;
    }
}

