/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.ImmutableSet;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import java.util.Set;

public class FinalParametersCheck
extends Check {
    private boolean mIgnorePrimitiveTypes;
    private final Set<Integer> mPrimitiveDataTypes = ImmutableSet.of((Object)51, (Object)53, (Object)54, (Object)56, (Object)55, (Object)57, (Object[])new Integer[]{50, 52});

    public void setIgnorePrimitiveTypes(boolean aIgnorePrimitiveTypes) {
        this.mIgnorePrimitiveTypes = aIgnorePrimitiveTypes;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{9, 8};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 8, 96, 156};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST container = aAST.getParent().getParent();
        if (container.getType() == 15) {
            return;
        }
        if (aAST.getType() == 96) {
            this.visitCatch(aAST);
        } else if (aAST.getType() == 156) {
            this.visitForEachClause(aAST);
        } else {
            this.visitMethod(aAST);
        }
    }

    private void visitMethod(DetailAST aMethod) {
        if (!aMethod.branchContains(21)) {
            return;
        }
        DetailAST modifiers = aMethod.findFirstToken(5);
        if (modifiers.branchContains(40)) {
            return;
        }
        DetailAST parameters = aMethod.findFirstToken(20);
        for (DetailAST child = parameters.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 21) continue;
            this.checkParam(child);
        }
    }

    private void visitCatch(DetailAST aCatch) {
        this.checkParam(aCatch.findFirstToken(21));
    }

    private void visitForEachClause(DetailAST aForEachClause) {
        this.checkParam(aForEachClause.findFirstToken(10));
    }

    private void checkParam(DetailAST aParam) {
        if (!aParam.branchContains(39) && !this.isIgnoredParam(aParam)) {
            DetailAST paramName = aParam.findFirstToken(58);
            DetailAST firstNode = CheckUtils.getFirstNode(aParam);
            this.log(firstNode.getLineNo(), firstNode.getColumnNo(), "final.parameter", paramName.getText());
        }
    }

    private boolean isIgnoredParam(DetailAST aParamDef) {
        DetailAST parameterType;
        boolean result = false;
        if (this.mIgnorePrimitiveTypes && this.mPrimitiveDataTypes.contains((parameterType = aParamDef.findFirstToken(13).getFirstChild()).getType())) {
            result = true;
        }
        return result;
    }
}

