/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AvoidEscapedUnicodeCharactersCheck
extends Check {
    private static Pattern sUnicodeRegexp = Utils.getPattern("\\\\u[a-fA-F0-9]{4}");
    private static Pattern sUnicodeControl = Utils.getPattern("\\\\(u|U)(00[0-1][0-1A-Fa-f]|00[8-9][0-9A-Fa-f]|034(f|F)|070(f|F)|180(e|E)|200[b-fB-F]|202[b-eB-E]|206[0-4a-fA-F]|[fF]{3}[9a-bA-B]|[fF][eE][fF]{2})");
    private static Pattern sCommentRegexp = Utils.getPattern(";[ ]*//+[a-zA-Z0-9 ]*|;[ ]*/[*]{1}+[a-zA-Z0-9 ]*");
    private static Pattern sAllEscapedChars = Utils.getPattern("^((\\\\u)[a-fA-F0-9]{4}||\\\\b|\\\\t|\\\\n|\\\\f|\\\\r|\\\\|\\\"|\\')+$");
    private static Pattern sNonPrintableChars = Utils.getPattern("\\\\u1680|\\\\u2028|\\\\u2029|\\\\u205(f|F)|\\\\u3000|\\\\u2007|\\\\u2000|\\\\u200(a|A)|\\\\u007(F|f)|\\\\u009(f|F)|\\\\u(f|F){4}|\\\\u007(F|f)|\\\\u00(a|A)(d|D)|\\\\u0600|\\\\u061(c|C)|\\\\u06(d|D){2}|\\\\u070(f|F)|\\\\u1680|\\\\u180(e|E)|\\\\u2000|\\\\u2028|\\\\u205(f|F)|\\\\u2066|\\\\u2067|\\\\u2068|\\\\u2069|\\\\u206(a|A)|\\\\u(d|D)800|\\\\u(f|F)(e|E)(f|F){2}|\\\\u(f|F){3}9|\\\\u(f|F){3}(a|A)|\\\\u0020|\\\\u00(a|A)0|\\\\u00(a|A)(d|D)|\\\\u0604|\\\\u061(c|C)|\\\\u06(d|D){2}|\\\\u070(f|F)|\\\\u1680|\\\\u180(e|E)|\\\\u200(f|F)|\\\\u202(f|F)|\\\\u2064|\\\\u2066|\\\\u2067|\\\\u2068|\\\\u2069|\\\\u206(f|F)|\\\\u(f|F)8(f|F){2}|\\\\u(f|F)(e|E)(f|F){2}|\\\\u(f|F){3}9|\\\\u(f|F){3}(b|B)|\\\\u05(d|D)0|\\\\u05(f|F)3|\\\\u0600|\\\\u0750|\\\\u0(e|E)00|\\\\u1(e|E)00|\\\\u2100|\\\\u(f|F)(b|B)50|\\\\u(f|F)(e|E)70|\\\\u(F|f){2}61|\\\\u04(f|F)9|\\\\u05(b|B)(e|E)|\\\\u05(e|E)(a|A)|\\\\u05(f|F)4|\\\\u06(f|F){2}|\\\\u077(f|F)|\\\\u0(e|E)7(f|F)|\\\\u20(a|A)(f|F)|\\\\u213(a|A)|\\\\u0000|\\\\u(f|F)(d|D)(f|F){2}|\\\\u(f|F)(e|E)(f|F){2}|\\\\u(f|F){2}(d|D)(c|C)|\\\\u2002|\\\\u0085|\\\\u200(a|A)|\\\\u2005|\\\\u2000|\\\\u2029|\\\\u000(B|b)|\\\\u2008|\\\\u2003|\\\\u205(f|F)|\\\\u1680|\\\\u0009|\\\\u0020|\\\\u2006|\\\\u2001|\\\\u202(f|F)|\\\\u00(a|A)0|\\\\u000(c|C)|\\\\u2009|\\\\u2004|\\\\u2028|\\\\u2028|\\\\u2007|\\\\u2004|\\\\u2028|\\\\u2007|\\\\u2025|\\\\u(f|F){2}0(e|E)|\\\\u(f|F){2}61");
    private boolean mAllowEscapesForControlCharacters;
    private boolean mAllowByTailComment;
    private boolean mAllowIfAllCharactersEscaped;
    private boolean mAllowNonPrintableEscapes;

    public final void setAllowEscapesForControlCharacters(boolean aAllow) {
        this.mAllowEscapesForControlCharacters = aAllow;
    }

    public final void setAllowByTailComment(boolean aAllow) {
        this.mAllowByTailComment = aAllow;
    }

    public final void setAllowIfAllCharactersEscaped(boolean aAllow) {
        this.mAllowIfAllCharactersEscaped = aAllow;
    }

    public final void setAllowNonPrintableEscapes(boolean aAllow) {
        this.mAllowNonPrintableEscapes = aAllow;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{139, 138};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        String literal = aAST.getText();
        if (!(!this.hasUnicodeChar(literal) || this.mAllowByTailComment && this.hasTrailComment(aAST) || this.isAllCharactersEscaped(literal) || this.mAllowEscapesForControlCharacters && this.isOnlyUnicodeValidChars(literal, sUnicodeControl) || this.mAllowNonPrintableEscapes && this.isOnlyUnicodeValidChars(literal, sNonPrintableChars))) {
            this.log(aAST.getLineNo(), "forbid.escaped.unicode.char", new Object[0]);
        }
    }

    private boolean hasUnicodeChar(String aLiteral) {
        return sUnicodeRegexp.matcher(aLiteral).find();
    }

    private boolean isOnlyUnicodeValidChars(String aLiteral, Pattern aPattern) {
        int unicodeValidMatchesCouter;
        int unicodeMatchesCounter = this.countMatches(sUnicodeRegexp, aLiteral);
        return unicodeMatchesCounter - (unicodeValidMatchesCouter = this.countMatches(aPattern, aLiteral)) == 0;
    }

    private boolean hasTrailComment(DetailAST aAst) {
        int lineNo;
        String currentLine;
        DetailAST semi;
        boolean result = false;
        DetailAST variableDef = this.getVariableDef(aAst);
        if (variableDef != null) {
            semi = variableDef.getNextSibling();
            if (semi.getType() != 45) {
                semi = variableDef.getLastChild();
            }
        } else {
            semi = this.getSemi(aAst);
        }
        if (semi != null && (currentLine = this.getLine((lineNo = semi.getLineNo()) - 1)) != null && sCommentRegexp.matcher(currentLine).find()) {
            result = true;
        }
        return result;
    }

    private int countMatches(Pattern aPattern, String aTarget) {
        int matcherCounter = 0;
        Matcher matcher = aPattern.matcher(aTarget);
        while (matcher.find()) {
            ++matcherCounter;
        }
        return matcherCounter;
    }

    private DetailAST getVariableDef(DetailAST aAst) {
        DetailAST result;
        for (result = aAst.getParent(); result != null && result.getType() != 10; result = result.getParent()) {
        }
        return result;
    }

    private DetailAST getSemi(DetailAST aAst) {
        DetailAST result;
        for (result = aAst.getParent(); result != null && result.getLastChild().getType() != 45; result = result.getParent()) {
        }
        if (result != null) {
            result = result.getLastChild();
        }
        return result;
    }

    private boolean isAllCharactersEscaped(String aLiteral) {
        return this.mAllowIfAllCharactersEscaped && sAllEscapedChars.matcher(aLiteral.substring(1, aLiteral.length() - 1)).find();
    }
}

