/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.BlockParentHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ElseHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;

public class IfHandler
extends BlockParentHandler {
    public IfHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "if", ast, parent);
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        if (child instanceof ElseHandler) {
            return this.getIndent();
        }
        return super.getSuggestedChildIndent(child);
    }

    @Override
    protected IndentLevel getIndentImpl() {
        if (this.isIfAfterElse()) {
            return this.getParent().getIndent();
        }
        return super.getIndentImpl();
    }

    private boolean isIfAfterElse() {
        DetailAST parent = this.getMainAst().getParent();
        return parent.getType() == 92 && parent.getLineNo() == this.getMainAst().getLineNo();
    }

    @Override
    protected void checkTopLevelToken() {
        if (this.isIfAfterElse()) {
            return;
        }
        super.checkTopLevelToken();
    }

    private void checkCondExpr() {
        DetailAST condAst = this.getMainAst().findFirstToken(76).getNextSibling();
        IndentLevel expected = new IndentLevel(this.getIndent(), this.getBasicOffset());
        this.checkExpressionSubtree(condAst, expected, false, false);
    }

    @Override
    public void checkIndentation() {
        super.checkIndentation();
        this.checkCondExpr();
        this.checkWrappingIndentation(this.getMainAst(), IfHandler.getIfStatementRightParen(this.getMainAst()));
    }

    private static DetailAST getIfStatementRightParen(DetailAST literalIfAst) {
        return literalIfAst.findFirstToken(77);
    }
}

