/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.HandlerFactory;
import com.puppycrawl.tools.checkstyle.checks.indentation.PrimordialHandler;
import java.util.ArrayDeque;
import java.util.Deque;

public class IndentationCheck
extends Check {
    private static final int DEFAULT_INDENTATION = 4;
    private final Deque<AbstractExpressionHandler> handlers = new ArrayDeque<AbstractExpressionHandler>();
    private final HandlerFactory handlerFactory = new HandlerFactory();
    private int basicOffset = 4;
    private int caseIndent = 4;
    private int braceAdjustment;
    private int throwsIndent = 4;
    private int arrayInitIndent = 4;
    private int lineWrappingIndentation = 4;
    private boolean forceStrictCondition;

    public boolean isForceStrictCondition() {
        return this.forceStrictCondition;
    }

    public void setForceStrictCondition(boolean value) {
        this.forceStrictCondition = value;
    }

    public void setBasicOffset(int basicOffset) {
        this.basicOffset = basicOffset;
    }

    public int getBasicOffset() {
        return this.basicOffset;
    }

    public void setBraceAdjustment(int adjustmentAmount) {
        this.braceAdjustment = adjustmentAmount;
    }

    public int getBraceAdjustment() {
        return this.braceAdjustment;
    }

    public void setCaseIndent(int amount) {
        this.caseIndent = amount;
    }

    public int getCaseIndent() {
        return this.caseIndent;
    }

    public void setThrowsIndent(int throwsIndent) {
        this.throwsIndent = throwsIndent;
    }

    public int getThrowsIndent() {
        return this.throwsIndent;
    }

    public void setArrayInitIndent(int arrayInitIndent) {
        this.arrayInitIndent = arrayInitIndent;
    }

    public int getArrayInitIndent() {
        return this.arrayInitIndent;
    }

    public int getLineWrappingIndentation() {
        return this.lineWrappingIndentation;
    }

    public void setLineWrappingIndentation(int lineWrappingIndentation) {
        this.lineWrappingIndentation = lineWrappingIndentation;
    }

    public void indentationLog(int line, String key, Object ... args) {
        this.log(line, key, args);
    }

    public int getIndentationTabWidth() {
        return this.getTabWidth();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.handlerFactory.getHandledTypes();
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void beginTree(DetailAST ast) {
        this.handlerFactory.clearCreatedHandlers();
        this.handlers.clear();
        PrimordialHandler primordialHandler = new PrimordialHandler(this);
        this.handlers.push(primordialHandler);
        primordialHandler.checkIndentation();
    }

    @Override
    public void visitToken(DetailAST ast) {
        AbstractExpressionHandler handler = this.handlerFactory.getHandler(this, ast, this.handlers.peek());
        this.handlers.push(handler);
        handler.checkIndentation();
    }

    @Override
    public void leaveToken(DetailAST ast) {
        this.handlers.pop();
    }

    final HandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }
}

