/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.ImmutableSet;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public class FinalParametersCheck
extends Check {
    public static final String MSG_KEY = "final.parameter";
    private final Set<Integer> primitiveDataTypes = ImmutableSet.of((Object)51, (Object)53, (Object)54, (Object)56, (Object)55, (Object)57, (Object[])new Integer[]{50, 52});
    private boolean ignorePrimitiveTypes;

    public void setIgnorePrimitiveTypes(boolean ignorePrimitiveTypes) {
        this.ignorePrimitiveTypes = ignorePrimitiveTypes;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{9, 8};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 8, 96, 156};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST container = ast.getParent().getParent();
        if (container.getType() == 15) {
            return;
        }
        if (ast.getType() == 96) {
            this.visitCatch(ast);
        } else if (ast.getType() == 156) {
            this.visitForEachClause(ast);
        } else {
            this.visitMethod(ast);
        }
    }

    private void visitMethod(DetailAST method) {
        if (!method.branchContains(21)) {
            return;
        }
        DetailAST modifiers = method.findFirstToken(5);
        if (modifiers.branchContains(40)) {
            return;
        }
        DetailAST parameters = method.findFirstToken(20);
        for (DetailAST child = parameters.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 21) continue;
            this.checkParam(child);
        }
    }

    private void visitCatch(DetailAST catchClause) {
        this.checkParam(catchClause.findFirstToken(21));
    }

    private void visitForEachClause(DetailAST forEachClause) {
        this.checkParam(forEachClause.findFirstToken(10));
    }

    private void checkParam(DetailAST param) {
        if (!param.branchContains(39) && !this.isIgnoredParam(param)) {
            DetailAST paramName = param.findFirstToken(58);
            DetailAST firstNode = CheckUtils.getFirstNode(param);
            this.log(firstNode.getLineNo(), firstNode.getColumnNo(), MSG_KEY, paramName.getText());
        }
    }

    private boolean isIgnoredParam(DetailAST paramDef) {
        DetailAST parameterType;
        boolean result = false;
        if (this.ignorePrimitiveTypes && this.primitiveDataTypes.contains((parameterType = paramDef.findFirstToken(13).getFirstChild()).getType())) {
            result = true;
        }
        return result;
    }
}

