/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.TextBlock;

public class Comment
implements TextBlock {
    private final String[] mText;
    private final int mFirstLine;
    private final int mLastLine;
    private final int mFirstCol;
    private final int mLastCol;

    public Comment(String[] aText, int aFirstCol, int aLastLine, int aLastCol) {
        this.mText = new String[aText.length];
        System.arraycopy(aText, 0, this.mText, 0, this.mText.length);
        this.mFirstLine = aLastLine - this.mText.length + 1;
        this.mLastLine = aLastLine;
        this.mFirstCol = aFirstCol;
        this.mLastCol = aLastCol;
    }

    @Override
    public final String[] getText() {
        return (String[])this.mText.clone();
    }

    @Override
    public final int getStartLineNo() {
        return this.mFirstLine;
    }

    @Override
    public final int getEndLineNo() {
        return this.mLastLine;
    }

    @Override
    public int getStartColNo() {
        return this.mFirstCol;
    }

    @Override
    public int getEndColNo() {
        return this.mLastCol;
    }

    @Override
    public boolean intersects(int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        long multiplier = Integer.MAX_VALUE;
        long thisStart = (long)this.mFirstLine * Integer.MAX_VALUE + (long)this.mFirstCol;
        long thisEnd = (long)this.mLastLine * Integer.MAX_VALUE + (long)this.mLastCol;
        long inStart = (long)aStartLineNo * Integer.MAX_VALUE + (long)aStartColNo;
        long inEnd = (long)aEndLineNo * Integer.MAX_VALUE + (long)aEndColNo;
        return thisEnd >= inStart && inEnd >= thisStart;
    }

    public String toString() {
        return "Comment[" + this.mFirstLine + ":" + this.mFirstCol + "-" + this.mLastLine + ":" + this.mLastCol + "]";
    }
}

