/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class CustomImportOrderCheck
extends Check {
    private static final String STATIC_RULE_GROUP = "STATIC";
    private static final String SAME_PACKAGE_RULE_GROUP = "SAME_PACKAGE";
    private static final String THIRD_PARTY_PACKAGE_RULE_GROUP = "THIRD_PARTY_PACKAGE";
    private static final String STANDARD_JAVA_PACKAGE_RULE_GROUP = "STANDARD_JAVA_PACKAGE";
    private static final String SPECIAL_IMPORTS_RULE_GROUP = "SPECIAL_IMPORTS";
    private static final String NON_GROUP_RULE_GROUP = "NON_GROUP";
    private String mSamePackageDomainsRegExp = "";
    private Pattern mStandardPackageRegExp = Utils.getPattern("java|javax");
    private Pattern mThirdPartyPackageRegExp = Utils.getPattern("^$");
    private Pattern mSpecialImportsRegExp = Utils.getPattern("^$");
    private boolean mSeparateLineBetweenGroups = true;
    private boolean mSortImportsInGroupAlphabetically;
    private final List<String> mCustomImportOrderRules = new ArrayList<String>();
    private int mSamePackageMatchingDepth = 2;
    private List<ImportDetails> mImportToGroupList = new ArrayList<ImportDetails>();

    public final void setStandardPackageRegExp(String aRegexp) {
        this.mStandardPackageRegExp = Utils.getPattern(aRegexp);
    }

    public final void setThirdPartyPackageRegExp(String aRegexp) {
        this.mThirdPartyPackageRegExp = Utils.getPattern(aRegexp);
    }

    public final void setSpecialImportsRegExp(String aRegexp) {
        this.mSpecialImportsRegExp = Utils.getPattern(aRegexp);
    }

    public final void setSeparateLineBetweenGroups(boolean aValue) {
        this.mSeparateLineBetweenGroups = aValue;
    }

    public final void setSortImportsInGroupAlphabetically(boolean aValue) {
        this.mSortImportsInGroupAlphabetically = aValue;
    }

    public final void setCustomImportOrderRules(String aInputCustomImportOrder) {
        this.mCustomImportOrderRules.clear();
        try {
            for (String currentState : aInputCustomImportOrder.split("\\s*###\\s*")) {
                this.addRulesToList(currentState);
            }
            this.mCustomImportOrderRules.add(NON_GROUP_RULE_GROUP);
        }
        catch (StringIndexOutOfBoundsException exp) {
            throw new RuntimeException("Unable to parse input rule: " + exp);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{31, 154, 16};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mImportToGroupList.clear();
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 16) {
            if (this.mCustomImportOrderRules.contains(SAME_PACKAGE_RULE_GROUP) && this.mSamePackageMatchingDepth != -1) {
                this.mSamePackageDomainsRegExp = CustomImportOrderCheck.createSamePackageRegexp(this.mSamePackageMatchingDepth, aAST);
            }
        } else {
            String importFullPath = CustomImportOrderCheck.getFullImportIdent(aAST);
            int lineNo = aAST.getLineNo();
            boolean isStatic = aAST.getType() == 154;
            this.mImportToGroupList.add(new ImportDetails(importFullPath, lineNo, this.getImportGroup(isStatic, importFullPath), isStatic));
        }
    }

    public void finishTree(DetailAST aRootAST) {
        if (this.mImportToGroupList.isEmpty()) {
            return;
        }
        ImportDetails firstImport = this.mImportToGroupList.get(0);
        String currentGroup = this.getImportGroup(firstImport.isStatic(), firstImport.getImportFullPath());
        int groupNumber = this.mCustomImportOrderRules.indexOf(currentGroup);
        String previousImport = null;
        for (ImportDetails importObject : this.mImportToGroupList) {
            String importGroup = importObject.getImportGroup();
            String fullImportIdent = importObject.mImportFullPath;
            if (!importGroup.equals(currentGroup)) {
                if (this.mCustomImportOrderRules.size() > groupNumber + 1) {
                    String nextGroup = this.getNextImportGroup(groupNumber + 1);
                    if (importGroup.equals(nextGroup)) {
                        if (this.mSeparateLineBetweenGroups && previousImport != null && !this.hasEmptyLineBefore(importObject.getLineNumber())) {
                            this.log(importObject.getLineNumber(), "custom.import.order.line.separator", fullImportIdent);
                        }
                        currentGroup = nextGroup;
                        groupNumber = this.mCustomImportOrderRules.indexOf(nextGroup);
                    } else {
                        this.logWrongImportGroupOrder(importObject.getLineNumber(), importGroup);
                    }
                } else {
                    this.logWrongImportGroupOrder(importObject.getLineNumber(), importGroup);
                }
            } else if (this.mSortImportsInGroupAlphabetically && previousImport != null && this.matchesImportGroup(importObject.isStatic(), fullImportIdent, currentGroup) && this.compare(fullImportIdent, previousImport) < 0) {
                this.log(importObject.getLineNumber(), "custom.import.order.lex", fullImportIdent);
            }
            previousImport = fullImportIdent;
        }
    }

    private void logWrongImportGroupOrder(int aCurrentImportLine, String aImportGroup) {
        if (NON_GROUP_RULE_GROUP.equals(aImportGroup)) {
            this.log(aCurrentImportLine, "custom.import.order.nongroup.import", new Object[0]);
        } else {
            this.log(aCurrentImportLine, "custom.import.order", aImportGroup);
        }
    }

    private String getNextImportGroup(int aCurrentGroupNumber) {
        int nextGroupNumber = aCurrentGroupNumber;
        while (this.mCustomImportOrderRules.size() > nextGroupNumber + 1 && !this.hasAnyImportInCurrentGroup(this.mCustomImportOrderRules.get(nextGroupNumber))) {
            ++nextGroupNumber;
        }
        return this.mCustomImportOrderRules.get(nextGroupNumber);
    }

    private boolean hasAnyImportInCurrentGroup(String aCurrentGroup) {
        for (ImportDetails currentImport : this.mImportToGroupList) {
            if (!aCurrentGroup.equals(currentImport.getImportGroup())) continue;
            return true;
        }
        return false;
    }

    private String getImportGroup(boolean aStatic, String aImportPath) {
        for (String group : this.mCustomImportOrderRules) {
            if (!this.matchesImportGroup(aStatic, aImportPath, group)) continue;
            return group;
        }
        return NON_GROUP_RULE_GROUP;
    }

    private boolean matchesImportGroup(boolean aStatic, String aImportPath, String aCurrentGroup) {
        return this.matchesStaticImportGroup(aStatic, aCurrentGroup) || this.matchesSamePackageImportGroup(aStatic, aImportPath, aCurrentGroup) || this.matchesSpecialImportsGroup(aStatic, aImportPath, aCurrentGroup) || this.matchesStandartImportGroup(aStatic, aImportPath, aCurrentGroup) || this.matchesThirdPartyImportGroup(aStatic, aImportPath, aCurrentGroup);
    }

    private boolean matchesStaticImportGroup(boolean aStatic, String aCurrentGroup) {
        return aStatic && STATIC_RULE_GROUP.equals(aCurrentGroup);
    }

    private boolean matchesSamePackageImportGroup(boolean aStatic, String aImportPath, String aCurrentGroup) {
        String importPath = aImportPath.substring(0, aImportPath.lastIndexOf("."));
        return !aStatic && SAME_PACKAGE_RULE_GROUP.equals(aCurrentGroup) && this.mSamePackageDomainsRegExp.contains(importPath);
    }

    private boolean matchesStandartImportGroup(boolean aStatic, String aCurrentImport, String aCurrentGroup) {
        return !aStatic && STANDARD_JAVA_PACKAGE_RULE_GROUP.equals(aCurrentGroup) && this.mStandardPackageRegExp.matcher(aCurrentImport).find();
    }

    private boolean matchesSpecialImportsGroup(boolean aStatic, String aCurrentImport, String aCurrentGroup) {
        return !aStatic && SPECIAL_IMPORTS_RULE_GROUP.equals(aCurrentGroup) && this.mSpecialImportsRegExp.matcher(aCurrentImport).find();
    }

    private boolean matchesThirdPartyImportGroup(boolean aStatic, String aCurrentImport, String aCurrentGroup) {
        return !aStatic && THIRD_PARTY_PACKAGE_RULE_GROUP.equals(aCurrentGroup) && this.mThirdPartyPackageRegExp.matcher(aCurrentImport).find() && !this.mStandardPackageRegExp.matcher(aCurrentImport).find();
    }

    private int compare(String aCurrentImport, String aPreviousImport) {
        int indexOfPreviousDotCurrent = 0;
        int indexOfNextDotCurrent = 0;
        String tokenCurrent = "";
        int indexOfPreviousDotPrevious = 0;
        int indexOfNextDotPrevious = 0;
        String tokenPrevious = "";
        int currentImportDomainCount = CustomImportOrderCheck.countDomains(aCurrentImport);
        int previousImportDomainCount = CustomImportOrderCheck.countDomains(aPreviousImport);
        int result = 0;
        while (aCurrentImport.lastIndexOf(".") != indexOfPreviousDotCurrent - 1 && aPreviousImport.lastIndexOf(".") != indexOfPreviousDotPrevious - 1) {
            indexOfNextDotCurrent = aCurrentImport.indexOf(".", indexOfPreviousDotCurrent + 1);
            indexOfNextDotPrevious = aPreviousImport.indexOf(".", indexOfPreviousDotPrevious + 1);
            tokenCurrent = aCurrentImport.substring(indexOfPreviousDotCurrent, indexOfNextDotCurrent);
            result = tokenCurrent.compareToIgnoreCase(tokenPrevious = aPreviousImport.substring(indexOfPreviousDotPrevious, indexOfNextDotPrevious));
            if (result != 0) {
                return result;
            }
            indexOfPreviousDotCurrent = indexOfNextDotCurrent + 1;
            indexOfPreviousDotPrevious = indexOfNextDotPrevious + 1;
        }
        if (result == 0 && (aCurrentImport.lastIndexOf(".") == indexOfPreviousDotCurrent - 1 || aPreviousImport.lastIndexOf(".") == indexOfPreviousDotPrevious - 1)) {
            if (currentImportDomainCount != previousImportDomainCount) {
                this.getClassName(indexOfNextDotPrevious, aPreviousImport);
                return currentImportDomainCount - previousImportDomainCount;
            }
            this.getClassName(indexOfNextDotPrevious, aPreviousImport);
            return this.getClassName(indexOfNextDotCurrent, aCurrentImport).compareToIgnoreCase(this.getClassName(indexOfNextDotPrevious, aPreviousImport));
        }
        return 0;
    }

    private String getClassName(int aStartFrom, String aImport) {
        String className = aImport;
        className = className.substring(aStartFrom, className.length());
        StringTokenizer token = new StringTokenizer(className, ".\r");
        return token.nextToken();
    }

    private static int countDomains(String aImportPath) {
        StringTokenizer tokens = new StringTokenizer(aImportPath, ".");
        int count = 0;
        while (tokens.hasMoreTokens() && !Character.isUpperCase(tokens.nextToken().toString().charAt(0))) {
            ++count;
        }
        return count - 1;
    }

    private boolean hasEmptyLineBefore(int aLineNo) {
        String lineBefore = this.getLines()[aLineNo - 2];
        return lineBefore.trim().isEmpty();
    }

    private static String getFullImportIdent(DetailAST aToken) {
        return aToken != null ? FullIdent.createFullIdent(aToken.findFirstToken(60)).getText() : "";
    }

    private void addRulesToList(String aRule) {
        if (STATIC_RULE_GROUP.equals(aRule) || THIRD_PARTY_PACKAGE_RULE_GROUP.equals(aRule) || STANDARD_JAVA_PACKAGE_RULE_GROUP.equals(aRule) || SPECIAL_IMPORTS_RULE_GROUP.equals(aRule)) {
            this.mCustomImportOrderRules.add(aRule);
        } else if (aRule.startsWith(SAME_PACKAGE_RULE_GROUP)) {
            String rule = aRule.substring(aRule.indexOf("(") + 1, aRule.indexOf(")"));
            try {
                this.mSamePackageMatchingDepth = Integer.parseInt(rule);
            }
            catch (Exception e) {
                this.mSamePackageDomainsRegExp = rule;
            }
            this.mCustomImportOrderRules.add(SAME_PACKAGE_RULE_GROUP);
        } else {
            throw new RuntimeException("Unexpected rule: " + aRule);
        }
    }

    private static String createSamePackageRegexp(int aCount, DetailAST aPackageNode) {
        StringBuilder builder = new StringBuilder();
        String packageFullPath = CustomImportOrderCheck.getFullImportIdent(aPackageNode);
        StringTokenizer tokens = new StringTokenizer(packageFullPath, ".");
        for (int count = aCount; tokens.hasMoreTokens() && count > 0; --count) {
            builder.append(tokens.nextToken()).append(".");
        }
        return builder.append("*").toString();
    }

    class ImportDetails {
        private String mImportFullPath;
        private int mLineNumber;
        private String mImportGroup;
        private boolean mStatic;

        public ImportDetails(String aImportFullPath, int aLineNumber, String aImportGroup, boolean aStatic) {
            this.setImportFullPath(aImportFullPath);
            this.setLineNumber(aLineNumber);
            this.setImportGroup(aImportGroup);
            this.setStatic(aStatic);
        }

        public String getImportFullPath() {
            return this.mImportFullPath;
        }

        public void setImportFullPath(String aImportFullPath) {
            this.mImportFullPath = aImportFullPath;
        }

        public int getLineNumber() {
            return this.mLineNumber;
        }

        public void setLineNumber(int aLineNumber) {
            this.mLineNumber = aLineNumber;
        }

        public String getImportGroup() {
            return this.mImportGroup;
        }

        public void setImportGroup(String aImportGroup) {
            this.mImportGroup = aImportGroup;
        }

        public boolean isStatic() {
            return this.mStatic;
        }

        public void setStatic(boolean aStatic) {
            this.mStatic = aStatic;
        }
    }
}

