/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.List;

public class AvoidStarImportCheck
extends Check {
    private final List<String> mExcludes = Lists.newArrayList();
    private boolean mAllowClassImports;
    private boolean mAllowStaticMemberImports;

    public int[] getDefaultTokens() {
        return new int[]{31, 154};
    }

    public void setExcludes(String[] aExcludes) {
        this.mExcludes.clear();
        for (String exclude : aExcludes) {
            this.mExcludes.add(exclude.endsWith(".*") ? exclude : exclude + ".*");
        }
    }

    public void setAllowClassImports(boolean aAllow) {
        this.mAllowClassImports = aAllow;
    }

    public void setAllowStaticMemberImports(boolean aAllow) {
        this.mAllowStaticMemberImports = aAllow;
    }

    public void visitToken(DetailAST aAST) {
        if (!this.mAllowClassImports && 31 == aAST.getType()) {
            DetailAST startingDot = aAST.getFirstChild();
            this.logsStarredImportViolation(startingDot);
        } else if (!this.mAllowStaticMemberImports && 154 == aAST.getType()) {
            DetailAST startingDot = aAST.getFirstChild().getNextSibling();
            this.logsStarredImportViolation(startingDot);
        }
    }

    private void logsStarredImportViolation(DetailAST aStartingDot) {
        FullIdent name = FullIdent.createFullIdent(aStartingDot);
        if (this.isStaredImport(name) && !this.mExcludes.contains(name.getText())) {
            this.log(aStartingDot.getLineNo(), "import.avoidStar", name.getText());
        }
    }

    private boolean isStaredImport(FullIdent aImportIdent) {
        return null != aImportIdent && aImportIdent.getText().endsWith(".*");
    }
}

