/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.ResourceBundle;

public final class TokenTypes {
    public static final int EOF = 1;
    public static final int MODIFIERS = 5;
    public static final int OBJBLOCK = 6;
    public static final int SLIST = 7;
    public static final int CTOR_DEF = 8;
    public static final int METHOD_DEF = 9;
    public static final int VARIABLE_DEF = 10;
    public static final int INSTANCE_INIT = 11;
    public static final int STATIC_INIT = 12;
    public static final int TYPE = 13;
    public static final int CLASS_DEF = 14;
    public static final int INTERFACE_DEF = 15;
    public static final int PACKAGE_DEF = 16;
    public static final int ARRAY_DECLARATOR = 17;
    public static final int EXTENDS_CLAUSE = 18;
    public static final int IMPLEMENTS_CLAUSE = 19;
    public static final int PARAMETERS = 20;
    public static final int PARAMETER_DEF = 21;
    public static final int LABELED_STAT = 22;
    public static final int TYPECAST = 23;
    public static final int INDEX_OP = 24;
    public static final int POST_INC = 25;
    public static final int POST_DEC = 26;
    public static final int METHOD_CALL = 27;
    public static final int METHOD_REF = 28;
    public static final int EXPR = 29;
    public static final int ARRAY_INIT = 30;
    public static final int IMPORT = 31;
    public static final int UNARY_MINUS = 32;
    public static final int UNARY_PLUS = 33;
    public static final int CASE_GROUP = 34;
    public static final int ELIST = 35;
    public static final int FOR_INIT = 36;
    public static final int FOR_CONDITION = 37;
    public static final int FOR_ITERATOR = 38;
    public static final int EMPTY_STAT = 39;
    public static final int FINAL = 40;
    public static final int ABSTRACT = 41;
    public static final int STRICTFP = 42;
    public static final int SUPER_CTOR_CALL = 43;
    public static final int CTOR_CALL = 44;
    public static final int SEMI = 46;
    public static final int RBRACK = 49;
    public static final int LITERAL_VOID = 50;
    public static final int LITERAL_BOOLEAN = 51;
    public static final int LITERAL_BYTE = 52;
    public static final int LITERAL_CHAR = 53;
    public static final int LITERAL_SHORT = 54;
    public static final int LITERAL_INT = 55;
    public static final int LITERAL_FLOAT = 56;
    public static final int LITERAL_LONG = 57;
    public static final int LITERAL_DOUBLE = 58;
    public static final int IDENT = 59;
    public static final int DOT = 60;
    public static final int STAR = 61;
    public static final int LITERAL_PRIVATE = 62;
    public static final int LITERAL_PUBLIC = 63;
    public static final int LITERAL_PROTECTED = 64;
    public static final int LITERAL_STATIC = 65;
    public static final int LITERAL_TRANSIENT = 66;
    public static final int LITERAL_NATIVE = 67;
    public static final int LITERAL_SYNCHRONIZED = 68;
    public static final int LITERAL_VOLATILE = 69;
    public static final int LITERAL_CLASS = 70;
    public static final int LITERAL_INTERFACE = 72;
    public static final int LCURLY = 73;
    public static final int RCURLY = 74;
    public static final int COMMA = 75;
    public static final int LPAREN = 77;
    public static final int RPAREN = 78;
    public static final int LITERAL_THIS = 79;
    public static final int LITERAL_SUPER = 80;
    public static final int ASSIGN = 81;
    public static final int LITERAL_THROWS = 82;
    public static final int COLON = 83;
    public static final int DOUBLE_COLON = 84;
    public static final int LITERAL_IF = 85;
    public static final int LITERAL_FOR = 93;
    public static final int LITERAL_WHILE = 86;
    public static final int LITERAL_DO = 87;
    public static final int DO_WHILE = 177;
    public static final int LITERAL_BREAK = 88;
    public static final int LITERAL_CONTINUE = 89;
    public static final int LITERAL_RETURN = 90;
    public static final int LITERAL_SWITCH = 91;
    public static final int LITERAL_THROW = 92;
    public static final int LITERAL_ELSE = 94;
    public static final int LITERAL_CASE = 95;
    public static final int LITERAL_DEFAULT = 96;
    public static final int LITERAL_TRY = 97;
    public static final int RESOURCE_SPECIFICATION = 178;
    public static final int RESOURCES = 179;
    public static final int RESOURCE = 180;
    public static final int LITERAL_CATCH = 98;
    public static final int LITERAL_FINALLY = 99;
    public static final int PLUS_ASSIGN = 100;
    public static final int MINUS_ASSIGN = 101;
    public static final int STAR_ASSIGN = 102;
    public static final int DIV_ASSIGN = 103;
    public static final int MOD_ASSIGN = 104;
    public static final int SR_ASSIGN = 105;
    public static final int BSR_ASSIGN = 106;
    public static final int SL_ASSIGN = 107;
    public static final int BAND_ASSIGN = 108;
    public static final int BXOR_ASSIGN = 109;
    public static final int BOR_ASSIGN = 110;
    public static final int QUESTION = 111;
    public static final int LOR = 112;
    public static final int LAND = 113;
    public static final int BOR = 114;
    public static final int BXOR = 115;
    public static final int BAND = 116;
    public static final int NOT_EQUAL = 117;
    public static final int EQUAL = 118;
    public static final int LT = 119;
    public static final int GT = 120;
    public static final int LE = 121;
    public static final int GE = 122;
    public static final int LITERAL_INSTANCEOF = 123;
    public static final int SL = 124;
    public static final int SR = 125;
    public static final int BSR = 126;
    public static final int PLUS = 127;
    public static final int MINUS = 128;
    public static final int DIV = 129;
    public static final int MOD = 130;
    public static final int INC = 131;
    public static final int DEC = 132;
    public static final int BNOT = 133;
    public static final int LNOT = 134;
    public static final int LITERAL_TRUE = 135;
    public static final int LITERAL_FALSE = 136;
    public static final int LITERAL_NULL = 137;
    public static final int LITERAL_NEW = 138;
    public static final int NUM_INT = 139;
    public static final int CHAR_LITERAL = 140;
    public static final int STRING_LITERAL = 141;
    public static final int NUM_FLOAT = 142;
    public static final int NUM_LONG = 143;
    public static final int NUM_DOUBLE = 144;
    public static final int LITERAL_ASSERT = 153;
    public static final int STATIC_IMPORT = 154;
    public static final int ENUM_DEF = 156;
    public static final int ENUM = 155;
    public static final int ENUM_CONSTANT_DEF = 157;
    public static final int FOR_EACH_CLAUSE = 158;
    public static final int ANNOTATION_DEF = 159;
    public static final int ANNOTATION_FIELD_DEF = 163;
    public static final int ANNOTATIONS = 160;
    public static final int ANNOTATION = 161;
    public static final int ANNOTATION_MEMBER_VALUE_PAIR = 162;
    public static final int ANNOTATION_ARRAY_INIT = 164;
    public static final int TYPE_PARAMETERS = 167;
    public static final int TYPE_PARAMETER = 168;
    public static final int TYPE_ARGUMENTS = 165;
    public static final int TYPE_ARGUMENT = 166;
    public static final int WILDCARD_TYPE = 169;
    public static final int TYPE_UPPER_BOUNDS = 170;
    public static final int TYPE_LOWER_BOUNDS = 171;
    public static final int AT = 172;
    public static final int ELLIPSIS = 173;
    public static final int TYPE_EXTENSION_AND = 176;
    public static final int GENERIC_START = 174;
    public static final int GENERIC_END = 175;
    public static final int LAMBDA = 181;
    private static final ImmutableMap<String, Integer> TOKEN_NAME_TO_VALUE;
    private static final String[] TOKEN_VALUE_TO_NAME;

    private TokenTypes() {
    }

    public static String getTokenName(int aID) {
        if (aID > TOKEN_VALUE_TO_NAME.length - 1) {
            throw new IllegalArgumentException("given id " + aID);
        }
        String name = TOKEN_VALUE_TO_NAME[aID];
        if (name == null) {
            throw new IllegalArgumentException("given id " + aID);
        }
        return name;
    }

    public static int getTokenId(String aName) {
        Integer id = (Integer)TOKEN_NAME_TO_VALUE.get((Object)aName);
        if (id == null) {
            throw new IllegalArgumentException("given name " + aName);
        }
        return id;
    }

    public static String getShortDescription(String aName) {
        if (!TOKEN_NAME_TO_VALUE.containsKey((Object)aName)) {
            throw new IllegalArgumentException("given name " + aName);
        }
        String tokentypes = "com.puppycrawl.tools.checkstyle.api.tokentypes";
        ResourceBundle bundle = ResourceBundle.getBundle("com.puppycrawl.tools.checkstyle.api.tokentypes");
        return bundle.getString(aName);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Field[] fields = TokenTypes.class.getDeclaredFields();
        String[] tempTokenValueToName = new String[]{};
        for (Field f : fields) {
            if (f.getType() != Integer.TYPE) continue;
            String name = f.getName();
            try {
                int tokenValue = f.getInt(name);
                builder.put((Object)name, (Object)tokenValue);
                if (tokenValue > tempTokenValueToName.length - 1) {
                    String[] temp = new String[tokenValue + 1];
                    System.arraycopy(tempTokenValueToName, 0, temp, 0, tempTokenValueToName.length);
                    tempTokenValueToName = temp;
                }
                tempTokenValueToName[tokenValue] = name;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                System.exit(1);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        TOKEN_NAME_TO_VALUE = builder.build();
        TOKEN_VALUE_TO_NAME = tempTokenValueToName;
    }
}

