/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.coding.AbstractIllegalCheck;
import java.util.Set;

public final class IllegalThrowsCheck
extends AbstractIllegalCheck {
    private static final String[] DEFAULT_IGNORED_METHOD_NAMES = new String[]{"finalize"};
    private final Set<String> mIgnoredMethodNames = Sets.newHashSet();

    public IllegalThrowsCheck() {
        super(new String[]{"Error", "RuntimeException", "Throwable", "java.lang.Error", "java.lang.RuntimeException", "java.lang.Throwable"});
        this.setIgnoredMethodNames(DEFAULT_IGNORED_METHOD_NAMES);
    }

    public int[] getDefaultTokens() {
        return new int[]{81};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST aDetailAST) {
        if (!this.shouldIgnoreMethod(aDetailAST.getParent().findFirstToken(58).getText())) {
            for (DetailAST token = aDetailAST.getFirstChild(); token != null; token = token.getNextSibling()) {
                FullIdent ident;
                if (token.getType() == 74 || !this.isIllegalClassName((ident = FullIdent.createFullIdent(token)).getText())) continue;
                this.log(token, "illegal.throw", ident.getText());
            }
        }
    }

    private boolean shouldIgnoreMethod(String aName) {
        return this.mIgnoredMethodNames.contains(aName);
    }

    public void setIgnoredMethodNames(String[] aMethodNames) {
        this.mIgnoredMethodNames.clear();
        for (String element : aMethodNames) {
            this.mIgnoredMethodNames.add(element);
        }
    }
}

