/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.JavadocCommentsTokenTypes;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.InvalidJavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import com.puppycrawl.tools.checkstyle.checks.javadoc.utils.BlockTagUtil;
import com.puppycrawl.tools.checkstyle.checks.javadoc.utils.InlineTagUtil;
import com.puppycrawl.tools.checkstyle.checks.javadoc.utils.TagInfo;
import com.puppycrawl.tools.checkstyle.utils.BlockCommentPosition;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class JavadocUtil {
    private static final Map<String, Integer> TOKEN_NAME_TO_VALUE;
    private static final Map<Integer, String> TOKEN_VALUE_TO_NAME;
    private static final String UNKNOWN_JAVADOC_TOKEN_ID_EXCEPTION_MESSAGE = "Unknown javadoc token id. Given id: ";
    private static final Pattern NEWLINE;
    private static final Pattern RETURN;
    private static final Pattern TAB;

    private JavadocUtil() {
    }

    public static JavadocTags getJavadocTags(TextBlock textBlock, JavadocTagType tagType) {
        boolean isInlineTags;
        boolean isBlockTags;
        ArrayList<TagInfo> tags = new ArrayList<TagInfo>();
        boolean bl = isBlockTags = tagType == JavadocTagType.ALL || tagType == JavadocTagType.BLOCK;
        if (isBlockTags) {
            tags.addAll(BlockTagUtil.extractBlockTags(textBlock.getText()));
        }
        boolean bl2 = isInlineTags = tagType == JavadocTagType.ALL || tagType == JavadocTagType.INLINE;
        if (isInlineTags) {
            tags.addAll(InlineTagUtil.extractInlineTags(textBlock.getText()));
        }
        ArrayList<JavadocTag> validTags = new ArrayList<JavadocTag>();
        ArrayList<InvalidJavadocTag> invalidTags = new ArrayList<InvalidJavadocTag>();
        for (TagInfo tag : tags) {
            int col = tag.getPosition().getColumn();
            int line = textBlock.getStartLineNo() + tag.getPosition().getLine() - 1;
            if (JavadocTagInfo.isValidName(tag.getName())) {
                validTags.add(new JavadocTag(line, col, tag.getName(), tag.getValue()));
                continue;
            }
            invalidTags.add(new InvalidJavadocTag(line, col, tag.getName()));
        }
        return new JavadocTags(validTags, invalidTags);
    }

    public static boolean isJavadocComment(String commentContent) {
        boolean result = false;
        if (!commentContent.isEmpty()) {
            char docCommentIdentifier = commentContent.charAt(0);
            result = docCommentIdentifier == '*';
        }
        return result;
    }

    public static boolean isJavadocComment(DetailAST blockCommentBegin) {
        String commentContent = JavadocUtil.getBlockCommentContent(blockCommentBegin);
        return JavadocUtil.isJavadocComment(commentContent) && JavadocUtil.isCorrectJavadocPosition(blockCommentBegin);
    }

    public static String getBlockCommentContent(DetailAST blockCommentBegin) {
        DetailAST commentContent = blockCommentBegin.getFirstChild();
        return commentContent.getText();
    }

    public static String getJavadocCommentContent(DetailAST javadocCommentBegin) {
        DetailAST commentContent = javadocCommentBegin.getFirstChild();
        return commentContent.getText().substring(1);
    }

    public static DetailNode findFirstToken(DetailNode detailNode, int type) {
        DetailNode returnValue = null;
        for (DetailNode node = detailNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != type) continue;
            returnValue = node;
            break;
        }
        return returnValue;
    }

    public static List<DetailNode> getAllNodesOfType(DetailNode detailNode, int type) {
        ArrayList<DetailNode> nodes = new ArrayList<DetailNode>();
        for (DetailNode node = detailNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != type) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static boolean isTag(DetailNode ast, String expectedTagName) {
        DetailNode htmlTagStart = JavadocUtil.findFirstToken(ast, 71);
        boolean isTag = false;
        if (htmlTagStart != null) {
            String tagName = JavadocUtil.findFirstToken(htmlTagStart, 26).getText();
            isTag = expectedTagName.equalsIgnoreCase(tagName);
        }
        return isTag;
    }

    public static DetailNode getNextSibling(DetailNode node, int tokenType) {
        DetailNode nextSibling;
        for (nextSibling = node.getNextSibling(); nextSibling != null && nextSibling.getType() != tokenType; nextSibling = nextSibling.getNextSibling()) {
        }
        return nextSibling;
    }

    public static String getTokenName(int id) {
        String name = TOKEN_VALUE_TO_NAME.get(id);
        if (name == null) {
            throw new IllegalArgumentException(UNKNOWN_JAVADOC_TOKEN_ID_EXCEPTION_MESSAGE + id);
        }
        return name;
    }

    public static int getTokenId(String name) {
        Integer id = TOKEN_NAME_TO_VALUE.get(name);
        if (id == null) {
            throw new IllegalArgumentException("Unknown javadoc token name. Given name " + name);
        }
        return id;
    }

    public static String getTagName(DetailNode javadocTagSection) {
        return JavadocUtil.findFirstToken(javadocTagSection.getFirstChild(), 26).getText();
    }

    public static String escapeAllControlChars(String text) {
        String textWithoutNewlines = NEWLINE.matcher(text).replaceAll("\\\\n");
        String textWithoutReturns = RETURN.matcher(textWithoutNewlines).replaceAll("\\\\r");
        return TAB.matcher(textWithoutReturns).replaceAll("\\\\t");
    }

    public static boolean isCorrectJavadocPosition(DetailAST blockComment) {
        DetailAST sibling = blockComment.getNextSibling();
        while (sibling != null) {
            if (sibling.getType() == 145) {
                if (JavadocUtil.isJavadocComment(JavadocUtil.getBlockCommentContent(sibling))) break;
                sibling = sibling.getNextSibling();
                continue;
            }
            if (sibling.getType() == 144) {
                sibling = sibling.getNextSibling();
                continue;
            }
            sibling = null;
        }
        return sibling == null && (BlockCommentPosition.isOnType(blockComment) || BlockCommentPosition.isOnMember(blockComment) || BlockCommentPosition.isOnPackage(blockComment));
    }

    static {
        NEWLINE = Pattern.compile("\n");
        RETURN = Pattern.compile("\r");
        TAB = Pattern.compile("\t");
        TOKEN_NAME_TO_VALUE = TokenUtil.nameToValueMapFromPublicIntFields(JavadocCommentsTokenTypes.class);
        TOKEN_VALUE_TO_NAME = TokenUtil.invertMap(TOKEN_NAME_TO_VALUE);
    }

    public static enum JavadocTagType {
        BLOCK,
        INLINE,
        ALL;

    }
}

